/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import junit.framework.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.RestClient;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidOperation
extends TestBase {
    private static JsonParser parser = new JsonParser();
    private RestClient client;
    private MDMHttpClient mdmHttpClient;

    @BeforeTest(alwaysRun=true, groups={"android-enrollment"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPURL, "application/json", accessTokenString);
        this.mdmHttpClient = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
    }

    @Test(groups={"operations"}, description="Test Android device lock operation.")
    public void testLock() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/lock", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device lock operation for invalid device id.")
    public void testLockWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/lock", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation.")
    public void testLocation() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/location", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device location                                                                           operation for invalid device id")
    public void testLocationWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/location", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation for two device ids including an invalid device id as the second one")
    public void testLocationForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/location", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device clear password operation.")
    public void testClearPassword() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/clear-password", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device clear password operation for invalid device id.")
    public void testClearPasswordWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/clear-password", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device clear password operation for two device ids including an invalid device id as the second one")
    public void testClearPasswordForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/clear-password", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device camera operation.")
    public void testCamera() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "camera");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/camera", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device camera operation for invalid device id.")
    public void testCameraWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "camera");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/camera", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device camera operation for two device ids including an invalid device id as the second one")
    public void testCameraForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "camera");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/camera", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device information operation.")
    public void testDeviceInfo() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/device-info", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android device information operation.")
    public void testDeviceInfoWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/device-info", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device device informationoperation for two device ids including an invalid device id as the second one")
    public void testDeviceInfoForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/device-info", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android enterprise-wipe operation.")
    public void testEnterpriseWipe() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/enterprise-wipe", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android enterprise-wipe operation for invalid device id.")
    public void testEnterpriseWipeWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/enterprise-wipe", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation for two device ids including an invalid device id as the second one")
    public void testEnterpriseWipeForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/enterprise-wipe", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android wipe data operation.")
    public void testWipeData() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wipe_data");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wipe-data", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android wipe data operation for invalid device id.")
    public void testWipeDataWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wipe_data");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wipe-data", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android wipe data operation for two device ids including an invalid device id as the second one.")
    public void testWipeDataForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wipe_data");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wipe-data", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android application list operation.")
    public void testApplicationList() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/application-list", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android application list operation for invalid device id.")
    public void testApplicationListWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/application-list", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation for two device ids including an invalid device id as the second one")
    public void testApplicationListForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/application-list", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android ring operation.")
    public void testRing() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/ring-device", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android ring operation forinvalid device id.")
    public void testRingWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/ring-device", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation for two device ids including an invalid device id as the second one")
    public void testRingForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/ring-device", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android mute operation.")
    public void testMute() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/mute", "[\"1234\"]");
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android mute operation for invalid device id.")
    public void testMuteWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/mute", "[\"1111\"]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android device location operation for two device ids including an invalid device id as the second one")
    public void testMuteForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/operation/mute", "[1234, 1111]");
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android install apps operation.")
    public void testInstallApps() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/install-application", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android install apps operation forinvalid device id")
    public void testInstallAppsWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/install-application", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android install apps operation fortwo device ids including an invalid device id as the second one")
    public void testInstallAppsForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/install-application", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android uninstall apps operation.")
    public void testUninstallApps() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/uninstall-application", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android uninstall apps operation for invalid device id")
    public void testUninstallAppsWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/uninstall-application", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android uninstall apps operation for two device ids including an invalid device id as the second one")
    public void testUninstallAppsForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/uninstall-application", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android blacklist apps operation.")
    public void testBlacklistApps() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/blacklist-applications", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android blacklist apps operationfor invalid device id")
    public void testBlacklistAppsWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/blacklist-applications", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android blacklist apps operationfor two device ids including an invalid device id as the second one")
    public void testBlacklistAppsForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/blacklist-applications", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android notification operation.")
    public void testNotification() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "notification");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/notification", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android notification operationfor invalid device id")
    public void testNotificationWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "notification");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/notification", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android notification operationfor two device ids including an invalid device id as the second one")
    public void testNotificationForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "notification");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/notification", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android WiFi operation.")
    public void testWiFi() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wifi");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wifi", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android WiFi operation forinvalid device id")
    public void testWiFiWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wifi");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wifi", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android WiFi operation fortwo device ids including an invalid device id as the second one")
    public void testWiFiForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "wifi");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/wifi", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android encrypt operation.")
    public void testEncrypt() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "encrypt");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/encrypt", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android encrypt operation forinvalid device id")
    public void testEncryptWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "encrypt");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/encrypt", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android encrypt operation fortwo device ids including an invalid device id as the second one")
    public void testEncryptForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "encrypt");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/encrypt", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android change lock operation.")
    public void testChangeLock() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "change_lock");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/change-lock-code", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android change lock operation forinvalid device id")
    public void testChangeLockWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "change_lock");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/change-lock-code", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android change lock operation fortwo device ids including an invalid device id as the second one")
    public void testChangeLockForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "change_lock");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/change-lock-code", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android password policy operation.")
    public void testPasswordPolicy() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "password_policy");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/password-policy", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android password policy operationfor invalid device id")
    public void testPasswordPolicyWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "password_policy");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/password-policy", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android password policy operationfor two device ids including an invalid device id as the second one")
    public void testPasswordPolicyForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "password_policy");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/password-policy", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android web clip operation.")
    public void testWebClip() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "web_clip");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/webclip", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(groups={"operations"}, description="Test Android web clip operation for invalid device id")
    public void testWebClipWithInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "web_clip");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/webclip", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 1", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test Android web clip operation for invalid device id")
    public void testWebClipForTwoDevicesWithOneInvalidDeviceId() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "web_clip");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID1 = new JsonPrimitive("1234");
        JsonPrimitive deviceID2 = new JsonPrimitive("1111");
        deviceIds.add((JsonElement)deviceID1);
        deviceIds.add((JsonElement)deviceID2);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.client.post("/mdm-android-agent/operation/webclip", operationData.toString());
        Assert.assertEquals((int)207, (int)response.getResponseCode());
        Assert.assertEquals((String)"Device Id not found for device found at 2", (String)response.getData().toString());
    }

    @Test(groups={"operations"}, description="Test get operations for list of android device")
    public void testGetListOfDevicesOperations() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.client.post("/mdm-android-agent/operation/ring-device", "[\"1234\"]");
        }
        String url = this.getDeviceOperationsURL("/mdm-admin/operations/paginate/android/");
        MDMResponse response = this.mdmHttpClient.get(url);
        JsonObject jsonObject = parser.parse(response.getBody()).getAsJsonObject();
        if (!jsonObject.has("recordsTotal")) {
            throw new Exception("\"recordsTotal\" attribute is missing in the response");
        }
        if (!jsonObject.has("recordsFiltered")) {
            throw new Exception("\"recordsFiltered\" attribute is missing in the response");
        }
        if (!jsonObject.has("draw")) {
            throw new Exception("\"draw\" attribute is missing in the response");
        }
        if (!jsonObject.has("data")) {
            throw new Exception("\"data\" attribute is missing in the response");
        }
        JsonArray jsonArray = jsonObject.getAsJsonArray("data");
        if (!"10".equals(String.valueOf(jsonArray.size()))) {
            throw new Exception("response array length is not equal to request length");
        }
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    private String getDeviceOperationsURL(String EndPoint) {
        return EndPoint + "1234" + "?start=" + "1" + "&length=" + "10";
    }
}

