/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.policy;

import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.RestClient;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidPolicy
extends TestBase {
    private RestClient client;

    @BeforeTest(alwaysRun=true, groups={"android-enrollment"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPURL, "application/json", accessTokenString);
    }

    @Test(groups={"android-policy"}, description="Test Android getEffectivePolicy.")
    public void testGetEffectivePolicy() throws Exception {
        HttpResponse response = this.client.get("/mdm-android-agent/policy/1234");
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-policy-response-payloads.json", "getEffectivePolicy").toString(), response.getData().toString(), true);
    }

    @Test(groups={"android-policy"}, description="Test Android getEffectivePolicy for invalid device id.")
    public void testGetEffectivePolicyWithInvalidDeviceId() throws Exception {
        HttpResponse response = this.client.get("/mdm-android-agent/policy/1111");
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-policy-erroneous-response-payloads.json", "getEffectivePolicy").toString(), response.getData().toString(), true);
    }
}

