/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.feature;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.TestBase;

public class FeatureManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"feature-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test view features.")
    public void testViewFeatures() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/features/android");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test view features with erroneous end point.")
    public void testViewFeaturesWithErroneousEndPoint() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/features");
        Assert.assertEquals((int)404, (int)response.getStatus());
    }
}

