/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.mobileDevice;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class MobileDeviceManagement
extends TestBase {
    private MDMHttpClient client;
    private static JsonParser parser = new JsonParser();

    @BeforeClass(alwaysRun=true, groups={"mobile-device-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Add an Android device.")
    public void addEnrollment() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        MDMResponse response = this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "POST").toString(), response.getBody(), true);
        this.enrollDevice("1235", "DEVICE_TWO");
        this.enrollDevice("1236", "DEVICE_THREE");
        this.enrollDevice("1237", "DEVICE_FOUR");
        this.enrollDevice("1238", "DEVICE_FIVE");
        this.enrollDevice("1239", "DEVICE_SIX");
        this.enrollDevice("1240", "DEVICE_SEVEN");
        this.enrollDevice("1241", "DEVICE_EIGHT");
        this.enrollDevice("1242", "DEVICE_NINE");
        this.enrollDevice("1243", "DEVICE_TEN");
    }

    private void enrollDevice(String deviceId, String deviceEnrollmentData) throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-additional-devices-payloads.json", deviceEnrollmentData);
        enrollmentData.addProperty("deviceIdentifier", deviceId);
        MDMResponse response = this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Test count devices")
    public void testCountDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices/count");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertTrue((boolean)response.getBody().equals("10"));
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Test view devices")
    public void testViewDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Test view device types")
    public void testViewDeviceTypes() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices/types");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayloadToString("mobile-device-mgt-view-device-types-response-payloads.json"), (String)response.getBody());
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Get 5 records of devices")
    public void testGetDevicesForSetOfDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?start=0&length=5");
        Assert.assertEquals((int)200, (int)response.getStatus());
        JsonObject jsonObject = parser.parse(response.getBody()).getAsJsonObject();
        Assert.assertTrue((String)"missing 'recordsTotal' attribute in response", (boolean)jsonObject.has("recordsTotal"));
        Assert.assertTrue((String)"missing 'recordsFiltered' attribute in response", (boolean)jsonObject.has("recordsFiltered"));
        Assert.assertTrue((String)"missing 'data' attribute in response", (boolean)jsonObject.has("data"));
        JsonArray jsonArray = jsonObject.getAsJsonArray("data");
        Assert.assertTrue((String)"response array length not equal to requested length", (boolean)String.valueOf(jsonArray.size()).equals("5"));
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Get all android devices")
    public void testGetAndroidDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?type=android");
        Assert.assertEquals((int)200, (int)response.getStatus());
        JsonArray jsonArray = parser.parse(response.getBody()).getAsJsonArray();
        Assert.assertTrue((String)"number of android devices in response not equal to the actual enrolled number.", (boolean)String.valueOf(jsonArray.size()).equals("10"));
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Get all windows devices")
    public void testGetWindowsDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?type=windows");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)"[]", (String)response.getBody().toString());
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Get all devices belongs to role admin")
    public void testGetDevicesBelongToAdmin() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?role=admin");
        Assert.assertEquals((int)200, (int)response.getStatus());
        JsonArray jsonArray = parser.parse(response.getBody()).getAsJsonArray();
        Assert.assertTrue((String)"number of devices in response not equal to the actual owned number.", (boolean)String.valueOf(jsonArray.size()).equals("10"));
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Test response for invalid start record number")
    public void testGetDevicesWithInvalidStartNumber() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?start=");
        Assert.assertEquals((int)404, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"addEnrollment"}, description="Test response for minus length")
    public void testGetDeviceWithMinusLength() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices?start=0&length=-2");
        Assert.assertEquals((int)200, (int)response.getStatus());
        JsonArray jsonArray = parser.parse(response.getBody()).getAsJsonArray();
        Assert.assertTrue((String)"number of android devices in response not equal to the actual enrolled number.", (boolean)String.valueOf(jsonArray.size()).equals("10"));
    }
}

