/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.mobileDevice;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.TestBase;

public class MobileDeviceManagementWithNoDevices
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"mobile-device-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test count devices with no added devices")
    public void testCountDevicesWithNoDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices/count");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)"0", (String)response.getBody());
    }

    @Test(description="Test view devices with no added devices")
    public void testViewDevicesWithNoDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/devices");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)"[]", (String)response.getBody());
    }
}

