/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.notification;

import com.google.gson.JsonObject;
import junit.framework.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class NotificationManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeTest(alwaysRun=true, groups={"notification-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
    }

    @Test(description="Test add notification.")
    public void testAddNotification() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/notifications", PayloadGenerator.getJsonPayload("notification-payloads.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("notification-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(description="Test add notification with erroneous payload.")
    public void testAddNotificationWithErroneousPayload() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/notifications", PayloadGenerator.getJsonPayload("notification-erroneous-payloads.json", "POST").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test update notification.", dependsOnMethods={"testAddNotification"})
    public void testUpdateNotification() throws Exception {
        MDMResponse response = this.client.put("/mdm-admin/notifications/1234567/NEW", PayloadGenerator.getJsonPayload("notification-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("notification-response-payloads.json", "PUT").toString(), response.getBody(), true);
    }

    @Test(description="Test get notification.", dependsOnMethods={"testUpdateNotification"})
    public void testGetNotification() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/notifications");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }
}

