/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.operation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.RestClient;
import org.wso2.mdm.integration.common.TestBase;

public class OperationManagement
extends TestBase {
    private JsonObject device;
    private MDMHttpClient client;
    private RestClient rclient;

    @BeforeClass(alwaysRun=true, groups={"api-policy-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
        this.rclient = new RestClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Add an Android device.")
    public void enrollAndroidDevice() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        MDMResponse response = this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(dependsOnMethods={"enrollAndroidDevice"}, description="Install an app to enrolled android device")
    public void testInstallApps() throws Exception {
        JsonObject operationData = PayloadGenerator.getJsonPayload("android-operation-payloads.json", "install_apps");
        JsonArray deviceIds = new JsonArray();
        JsonPrimitive deviceID = new JsonPrimitive("1234");
        deviceIds.add((JsonElement)deviceID);
        operationData.add("deviceIDs", (JsonElement)deviceIds);
        HttpResponse response = this.rclient.post("/mdm-android-agent/operation/install-application", operationData.toString());
        Assert.assertEquals((int)201, (int)response.getResponseCode());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get device apps with wrong Device ID")
    public void testGetDeviceAppsWithWrongDeviceID() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/operations/android/1111/apps");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get operations for device with wrong Device ID")
    public void testGetDeviceOperationsWithWrongDeviceID() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/operations/android/1111");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get operations for android device")
    public void testGetDeviceOperations() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/operations/android/1234");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(dependsOnMethods={"testInstallApps"}, description="Test get device apps for android deviceD")
    public void testGetDeviceApps() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/operations/android/1234/apps");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }
}

