/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.policy;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidPolicyManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"policy-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test add policy.")
    public void testAddPolicy() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/active-policy", PayloadGenerator.getJsonPayload("android-policy-payloads.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "POST").toString(), (String)response.getBody());
    }

    @Test(description="Test add policy with erroneous payload.")
    public void testAddPolicyWithErroneousPayload() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/active-policy", PayloadGenerator.getJsonPayload("policy-erroneous-payloads.json", "POST").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test view policy list.", dependsOnMethods={"testAddPolicy"})
    public void testViewPolicyList() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/policies");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test update policy.", dependsOnMethods={"testViewPolicyList"})
    public void testUpdatePolicy() throws Exception {
        MDMResponse response = this.client.put("/mdm-admin/policies/1", PayloadGenerator.getJsonPayload("android-policy-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test update policy with erroneous payload.", dependsOnMethods={"testAddPolicy"})
    public void testUpdatePolicyWithErroneousPayload() throws Exception {
        MDMResponse response = this.client.put("/mdm-admin/policies/1", PayloadGenerator.getJsonPayload("policy-erroneous-payloads.json", "POST").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test remove policy.", dependsOnMethods={"testUpdatePolicy"})
    public void testRemovePolicy() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/bulk-remove", "[1]");
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "DELETE").toString(), (String)response.getBody());
    }

    @Test(description="Test remove policy without a policies.", dependsOnMethods={"testRemovePolicy"})
    public void testRemovePolicyWithoutPolicies() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/bulk-remove", "[1]");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }
}

