/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.policy;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.Constants;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class WindowsPolicyManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"policy-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test add policy.")
    public void testAddPolicy() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/active-policy", PayloadGenerator.getJsonPayload("windows-policy-payloads.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "POST").toString(), (String)response.getBody());
    }

    @Test(description="Test add second policy.", dependsOnMethods={"testAddPolicy"})
    public void testAddSecondPolicy() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/active-policy", PayloadGenerator.getJsonPayload("windows-add-second-policy-payload.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "POST").toString(), (String)response.getBody());
    }

    @Test(description="Test get all policies.", dependsOnMethods={"testAddSecondPolicy"})
    public void testGetAllPolicies() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/policies");
        Assert.assertEquals((int)200, (int)response.getStatus());
        this.setPolicyIDs(response.getBody());
    }

    @Test(description="Test policy priorities.", dependsOnMethods={"testGetAllPolicies"})
    public void testPolicyPriorities() throws Exception {
        MDMResponse response = this.client.put("/mdm-admin/policies/priorities", Constants.PolicyManagement.POLICY_PRIORITIES_PAYLOAD_FILE_NAME);
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-priories-response-payloads.json", "PUT").toString(), (String)response.getBody());
    }

    @Test(description="Test policy priorities with erroneous payload.", dependsOnMethods={"testGetAllPolicies"})
    public void testPolicyPrioritiesWithErroneousPayload() throws Exception {
        MDMResponse response = this.client.put("/mdm-admin/policies/priorities", "[{\"id\":1,\"priority\":1},{\"id\":1,\"priority\":2}]");
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test update policy.", dependsOnMethods={"testPolicyPriorities"})
    public void testUpdatePolicy() throws Exception {
        MDMResponse response = this.client.put(Constants.PolicyManagement.UPDATE_WINDOWS_POLICY_ENDPOINT, PayloadGenerator.getJsonPayload("windows-policy-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "PUT").toString(), (String)response.getBody());
    }

    @Test(description="Test remove policy.", dependsOnMethods={"testUpdatePolicy"})
    public void testRemovePolicy() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/policies/bulk-remove", Constants.PolicyManagement.REMOVE_WINDOWS_POLICY_PAYLOAD_FILE_NAME);
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)PayloadGenerator.getJsonPayload("policy-response-payloads.json", "DELETE").toString(), (String)response.getBody());
    }

    private void setPolicyIDs(String JsonString) throws IOException {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(JsonString).getAsJsonObject();
        JsonArray policies = (JsonArray)jsonObject.get("responseContent");
        this.setPolicyIDs(String.valueOf(policies.get(0).getAsJsonObject().get("id")), String.valueOf(policies.get(1).getAsJsonObject().get("id")));
    }

    private void setPolicyIDs(String ID, String SecondID) {
        Constants.PolicyManagement.WINDOWS_POLICY_DEVICE_ID = ID;
        Constants.PolicyManagement.WINDOWS_POLICY_SECOND_DEVICE_ID = SecondID;
        Constants.PolicyManagement.POLICY_PRIORITIES_PAYLOAD_FILE_NAME = "[{\"id\":" + ID + ",\"priority\":1}," + "{\"id\":" + SecondID + ",\"priority\":2}]";
        Constants.PolicyManagement.UPDATE_WINDOWS_POLICY_ENDPOINT = "/mdm-admin/policies/" + ID;
        Constants.PolicyManagement.REMOVE_WINDOWS_POLICY_PAYLOAD_FILE_NAME = "[" + ID + "," + "" + SecondID + "]";
    }
}

