/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.role;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class RoleManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"role-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test add role.")
    public void testAddRole() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "administration");
        MDMResponse response = this.client.post(url, PayloadGenerator.getJsonPayload("role-payloads.json", "POST").toString());
        Assert.assertEquals((int)201, (int)response.getStatus());
    }

    @Test(description="Test view roles")
    public void testViewRoles() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/roles");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("role-response-payloads.json", "GET").toString(), response.getBody(), true);
    }

    @Test(description="Test add role with erroneous payload.")
    public void testAddRoleWithErroneousPayload() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "administration");
        MDMResponse response = this.client.post(url, PayloadGenerator.getJsonPayload("role-erroneous-payloads.json", "POST").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test update role.", dependsOnMethods={"testAddRole"})
    public void testUpdateUser() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "administration");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("role-update-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test update role with erroneous payload.", dependsOnMethods={"testAddRole"})
    public void testUpdateRoleWithErroneousPayload() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "administration");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("role-erroneous-payloads.json", "PUT").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test update permission role.", dependsOnMethods={"testUpdateUser"})
    public void testUpdateRolePermission() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "manager");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("role-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test update role with erroneous payload.", dependsOnMethods={"testUpdateUser"})
    public void testUpdateRolePermissionWithErroneousPayload() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "manager");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("role-erroneous-payloads.json", "PUT").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test remove role.", dependsOnMethods={"testUpdateRolePermission"})
    public void testRemoveRole() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "manager");
        MDMResponse response = this.client.delete(url);
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(description="Test remove role without roles.", dependsOnMethods={"testUpdateRolePermission"})
    public void testRemoveRoleWithoutRoles() throws Exception {
        String url = this.GetURL("/mdm-admin/roles", "manager");
        MDMResponse response = this.client.delete(url);
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    private String GetURL(String endPoint, String param) {
        return endPoint + "?rolename=" + param;
    }
}

