/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.user;

import java.io.IOException;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class UserManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"user-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test view users without users.")
    public void testViewUserWithoutUsers() throws Exception {
        String url = this.GetURL("/mdm-admin/users/view");
        MDMResponse response = this.client.get(url);
        Assert.assertEquals((int)404, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-erroneous-response-payloads.json", "GET").toString(), response.getBody(), true);
    }

    @Test(description="Test update user without a user", dependsOnMethods={"testViewUserWithoutUsers"})
    public void testUpdateUserWithoutUser() throws Exception {
        String url = this.GetURL("/mdm-admin/users");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("user-erroneous-payloads.json", "PUT").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-erroneous-response-payloads.json", "PUT").toString(), response.getBody(), true);
    }

    @Test(description="Test add user.", dependsOnMethods={"testUpdateUserWithoutUser"})
    public void testAddUser() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/users", PayloadGenerator.getJsonPayload("user-payloads.json", "POST").toString());
        Assert.assertEquals((int)201, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(description="Test add user with erroneous payload")
    public void testAddUserWithErroneousPayload() throws IOException {
        MDMResponse response = this.client.post("/mdm-admin/users", PayloadGenerator.getJsonPayload("user-erroneous-payloads.json", "POST").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-erroneous-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(description="Test update user.", dependsOnMethods={"testAddUser"})
    public void testUpdateUser() throws Exception {
        String url = this.GetURL("/mdm-admin/users");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("user-payloads.json", "PUT").toString());
        Assert.assertEquals((int)201, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-response-payloads.json", "PUT").toString(), response.getBody(), true);
    }

    @Test(description="Test update user with erroneous payload", dependsOnMethods={"testAddUser"})
    public void testUpdateUserWithErroneousPayload() throws Exception {
        String url = this.GetURL("/mdm-admin/users");
        MDMResponse response = this.client.put(url, PayloadGenerator.getJsonPayload("user-erroneous-payloads.json", "PUT").toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-erroneous-response-payloads.json", "PUT").toString(), response.getBody(), true);
    }

    @Test(description="Test view user.", dependsOnMethods={"testUpdateUser"})
    public void testViewUser() throws Exception {
        String url = this.GetURL("/mdm-admin/users/view");
        MDMResponse response = this.client.get(url);
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-response-payloads.json", "GET").toString(), response.getBody(), true);
    }

    @Test(description="Test remove user.", dependsOnMethods={"testViewUser"})
    public void testRemoveUser() throws Exception {
        String url = this.GetURL("/mdm-admin/users");
        MDMResponse response = this.client.delete(url);
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-response-payloads.json", "DELETE").toString(), response.getBody(), true);
    }

    @Test(description="Test remove user with erroneous.", dependsOnMethods={"testRemoveUser"})
    public void testRemoveUserWithErroneous() throws Exception {
        String url = this.GetURL("/mdm-admin/users");
        MDMResponse response = this.client.delete(url);
        Assert.assertEquals((int)400, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("user-erroneous-response-payloads.json", "DELETE").toString(), response.getBody(), true);
    }

    private String GetURL(String endPoint) {
        return endPoint + "?username=" + "username123";
    }
}

