/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.InMemoryMessageAggregator;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.common.data.types.ShortString;

public class BasicPublish
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicPublish.class);
    private final ShortString exchange;
    private final ShortString routingKey;
    private final boolean mandatory;
    private final boolean immediate;

    public BasicPublish(int channel, ShortString exchange, ShortString routingKey, boolean mandatory, boolean immediate) {
        super(channel, (short)60, (short)40);
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.mandatory = mandatory;
        this.immediate = immediate;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.exchange.getSize() + this.routingKey.getSize() + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.exchange.write(buf);
        this.routingKey.write(buf);
        byte flags = 0;
        if (this.mandatory) {
            flags = (byte)(flags | 1);
        }
        if (this.immediate) {
            flags = (byte)(flags | 2);
        }
        buf.writeByte((int)flags);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        InMemoryMessageAggregator inMemoryMessageAggregator = channel.getMessageAggregator();
        inMemoryMessageAggregator.basicPublishReceived(this.routingKey, this.exchange);
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString exchange = ShortString.parse((ByteBuf)buf);
            ShortString routingKey = ShortString.parse((ByteBuf)buf);
            byte flags = buf.readByte();
            boolean mandatory = (flags & 1) == 1;
            boolean immediate = (flags & 2) == 2;
            return new BasicPublish(channel, exchange, routingKey, mandatory, immediate);
        };
    }
}

