/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpConnectionHandler;
import org.wso2.broker.amqp.codec.ConnectionException;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelOpenOk;
import org.wso2.broker.amqp.codec.frames.ConnectionClose;
import org.wso2.broker.amqp.codec.frames.MethodFrame;

public class ChannelOpen
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelOpen.class);
    private static final short CLASS_ID = 20;
    private static final short METHOD_ID = 10;

    public ChannelOpen(int channel) {
        super(channel, (short)20, (short)10);
    }

    @Override
    protected long getMethodBodySize() {
        return 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeByte(0);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        try {
            int channelId = this.getChannel();
            connectionHandler.createChannel(channelId);
            ctx.writeAndFlush((Object)new ChannelOpenOk(channelId));
        }
        catch (ConnectionException e) {
            LOGGER.warn("Error while creating channel for ID " + this.getChannel(), (Throwable)e);
            ctx.writeAndFlush((Object)ConnectionClose.getInstance((short)20, (short)10, e));
        }
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            short stringSize = buf.readUnsignedByte();
            buf.skipBytes((int)stringSize);
            return new ChannelOpen(channel);
        };
    }
}

