/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.flow;

import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.ChannelFlow;

public class ChannelFlowManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFlowManager.class);
    private final int highLimit;
    private final int lowLimit;
    private int messagesInFlight = 0;
    private boolean inflowEnabled = true;
    private final AmqpChannel channel;

    public ChannelFlowManager(AmqpChannel channel, int lowLimit, int highLimit) {
        this.channel = channel;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
    }

    public void notifyMessageAddition(ChannelHandlerContext ctx) {
        ++this.messagesInFlight;
        if (this.messagesInFlight > this.highLimit && this.inflowEnabled) {
            this.inflowEnabled = false;
            ctx.writeAndFlush((Object)new ChannelFlow(this.channel.getChannelId(), false));
            LOGGER.info("Inflow disabled for channel {}-{}", (Object)this.channel.getChannelId(), (Object)ctx.channel().remoteAddress());
        }
    }

    public void notifyMessageRemoval(ChannelHandlerContext ctx) {
        --this.messagesInFlight;
        if (this.messagesInFlight < this.lowLimit && !this.inflowEnabled) {
            this.inflowEnabled = true;
            ctx.writeAndFlush((Object)new ChannelFlow(this.channel.getChannelId(), true));
            LOGGER.info("Inflow enabled for channel {}-{}", (Object)this.channel.getChannelId(), (Object)ctx.channel().remoteAddress());
        }
    }
}

