/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ConnectionClose;
import org.wso2.broker.amqp.codec.frames.ConnectionSecure;
import org.wso2.broker.amqp.codec.frames.ConnectionTune;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortString;

public class ConnectionSecureOk
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionSecureOk.class);
    private final LongString response;

    public ConnectionSecureOk(int channel, LongString response) {
        super(channel, (short)10, (short)21);
        this.response = response;
    }

    @Override
    protected long getMethodBodySize() {
        return this.response.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.response.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.fireChannelRead(() -> {
            block6: {
                try {
                    SaslServer saslServer = connectionHandler.getSaslServer();
                    if (saslServer != null) {
                        byte[] challenge = saslServer.evaluateResponse(this.response.getBytes());
                        if (saslServer.isComplete()) {
                            ctx.writeAndFlush((Object)new ConnectionTune(256, 65535L, 0));
                        } else {
                            ctx.writeAndFlush((Object)new ConnectionSecure(this.getChannel(), LongString.parse((byte[])challenge)));
                        }
                        break block6;
                    }
                    throw new SaslException("Sasl server hasn't been set during connection start");
                }
                catch (SaslException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Exception occurred while authenticating incoming connection ", (Throwable)e);
                    }
                    String replyText = "Authentication Failed";
                    ctx.writeAndFlush((Object)new ConnectionClose(403, ShortString.parseString((String)replyText), 10, 21));
                }
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            LongString response = LongString.parse((ByteBuf)buf);
            return new ConnectionSecureOk(channel, response);
        };
    }
}

