/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.Server;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.configuration.BrokerConfiguration;
import org.yaml.snakeyaml.Yaml;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws InterruptedException {
        BrokerConfiguration configuration = Main.loadConfiguration();
        Broker broker = new Broker(configuration);
        broker.startMessageDelivery();
        Server amqpServer = new Server(broker, configuration);
        amqpServer.run();
    }

    private static BrokerConfiguration loadConfiguration() {
        BrokerConfiguration configuration = null;
        File brokerYamlFile = null;
        String brokerFilePath = System.getProperty("broker.config");
        brokerYamlFile = brokerFilePath == null || brokerFilePath.trim().isEmpty() ? Paths.get("", "broker.yaml").toAbsolutePath().toFile() : Paths.get(brokerFilePath, new String[0]).toAbsolutePath().toFile();
        InputStream yamlStream = null;
        try {
            if (brokerYamlFile.canRead()) {
                yamlStream = new FileInputStream(brokerYamlFile);
            } else {
                log.info("using in-built configuration file -broker.yaml");
                yamlStream = Main.class.getResourceAsStream("/broker.yaml");
                if (yamlStream == null) {
                    throw new FileNotFoundException("unable to find - broker.yaml in class path");
                }
            }
            Yaml yaml = new Yaml();
            configuration = (BrokerConfiguration)yaml.loadAs(yamlStream, BrokerConfiguration.class);
        }
        catch (FileNotFoundException e) {
            String msg = "unable to find - broker.yaml broker will terminate now";
            log.warn(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            try {
                if (yamlStream != null) {
                    yamlStream.close();
                }
            }
            catch (IOException e) {
                log.error("error while closing file - broker.yaml", (Throwable)e);
            }
        }
        return configuration;
    }
}

