/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.Server;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;
import org.wso2.broker.core.Broker;
import org.wso2.broker.core.configuration.BrokerConfiguration;
import org.wso2.broker.core.security.authentication.user.User;
import org.wso2.broker.core.security.authentication.user.UserStoreManager;
import org.wso2.broker.core.security.authentication.user.UsersFile;
import org.wso2.broker.rest.BrokerRestServer;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        try {
            StartupContext startupContext = new StartupContext();
            Main.initConfigProvider(startupContext);
            Main.loadUsers();
            BrokerConfigProvider service = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
            BrokerConfiguration brokerConfiguration = (BrokerConfiguration)service.getConfigurationObject("org.wso2.broker", BrokerConfiguration.class);
            DataSource dataSource = Main.getDataSource(brokerConfiguration.getDataSource());
            startupContext.registerService(DataSource.class, (Object)dataSource);
            BrokerRestServer restServer = new BrokerRestServer(startupContext);
            Broker broker = new Broker(startupContext);
            broker.startMessageDelivery();
            Server amqpServer = new Server(startupContext);
            amqpServer.start();
            restServer.start();
            amqpServer.awaitServerClose();
            restServer.stop();
            broker.stopMessageDelivery();
        }
        catch (Throwable e) {
            LOGGER.error("Error while starting broker", e);
            throw e;
        }
    }

    private static DataSource getDataSource(BrokerConfiguration.DataSourceConfiguration dataSourceConfiguration) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(dataSourceConfiguration.getUrl());
        config.setUsername(dataSourceConfiguration.getUser());
        config.setPassword(dataSourceConfiguration.getPassword());
        config.setAutoCommit(false);
        return new HikariDataSource(config);
    }

    private static void initConfigProvider(StartupContext startupContext) throws ConfigurationException {
        String brokerFilePath = System.getProperty("broker.config");
        Path brokerYamlFile = brokerFilePath == null || brokerFilePath.trim().isEmpty() ? Paths.get("", "broker.yaml").toAbsolutePath() : Paths.get(brokerFilePath, new String[0]).toAbsolutePath();
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider((Path)brokerYamlFile, null);
        startupContext.registerService(BrokerConfigProvider.class, (arg_0, arg_1) -> ((ConfigProvider)configProvider).getConfigurationObject(arg_0, arg_1));
    }

    private static void loadUsers() throws ConfigurationException {
        String usersFilePath = System.getProperty("broker.users.config");
        Path usersYamlFile = usersFilePath == null || usersFilePath.trim().isEmpty() ? Paths.get("", "users.yaml").toAbsolutePath() : Paths.get(usersFilePath, new String[0]).toAbsolutePath();
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider((Path)usersYamlFile, null);
        UsersFile usersFile = (UsersFile)configProvider.getConfigurationObject("broker.users", UsersFile.class);
        if (usersFile != null) {
            List users = usersFile.getUsers();
            for (User user : users) {
                UserStoreManager.addUser((User)user);
            }
        }
    }
}

