/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.CarbonStartupHandler;
import org.wso2.carbon.kernel.internal.startupresolver.OSGiServiceCapabilityTracker;
import org.wso2.carbon.kernel.internal.startupresolver.StartupComponentManager;
import org.wso2.carbon.kernel.internal.startupresolver.StartupOrderResolverUtils;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.utils.manifest.ManifestElement;

@Component(name="org.wso2.carbon.kernel.internal.startupresolver.StartupOrderResolver", immediate=true)
public class StartupOrderResolver {
    private static final Logger logger = LoggerFactory.getLogger(StartupOrderResolver.class);
    private StartupComponentManager startupComponentManager = new StartupComponentManager();
    private OSGiServiceCapabilityTracker osgiServiceTracker;
    private Timer capabilityListenerTimer = new Timer();
    private Timer pendingCapabilityTimer = new Timer();
    private CarbonRuntime carbonRuntime;

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        try {
            logger.debug("Initialize - Startup Order Resolver.");
            this.processManifestHeaders(Arrays.asList(bundleContext.getBundles()));
            this.startCapabilityTrackers();
            this.scheduleCapabilityListenerTimer();
            this.schedulePendingCapabilityTimerTask();
        }
        catch (Throwable e) {
            logger.error("Error occurred in Startup Order Resolver.", e);
        }
    }

    @Deactivate
    public void stop(BundleContext bundleContext) throws Exception {
        logger.debug("Deactivating startup resolver component available in bundle {}", (Object)bundleContext.getBundle().getSymbolicName());
    }

    @Reference(name="carbon.startup.order.resolver.carbon.runtime", service=CarbonRuntime.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = carbonRuntime;
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime) {
        this.carbonRuntime = null;
    }

    private void processManifestHeaders(List<Bundle> bundleList) {
        Map<String, List<ManifestElement>> groupedManifestElements = bundleList.stream().filter(StartupOrderResolverUtils::isCarbonComponentHeaderPresent).map(StartupOrderResolverUtils::getManifestElements).flatMap(Collection::stream).collect(Collectors.groupingBy(ManifestElement::getValue));
        if (groupedManifestElements.get("startup.listener") != null) {
            this.processServiceComponents(groupedManifestElements);
        }
        if (groupedManifestElements.get("osgi.service") != null) {
            this.processCapabilityProviders(groupedManifestElements.get("osgi.service"));
            this.processOSGiServices(groupedManifestElements.get("osgi.service"));
        }
    }

    private void scheduleCapabilityListenerTimer() {
        final CarbonConfiguration carbonConfiguration = this.carbonRuntime.getConfiguration();
        long capabilityListenerTimerDelay = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getDelay();
        long capabilityListenerTimerPeriod = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getPeriod();
        this.capabilityListenerTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<StartupComponentManager> clazz = StartupComponentManager.class;
                synchronized (StartupComponentManager.class) {
                    if (StartupOrderResolver.this.startupComponentManager.getComponents(StartupComponent::isPending).size() == 0) {
                        StartupOrderResolver.this.startupComponentManager.notifySatisfiableComponents();
                        logger.debug("All the StartupComponents are satisfied. Cancelling the capabilityListenerTimer");
                        CarbonStartupHandler.logServerStartupTime(carbonConfiguration.getName());
                        CarbonStartupHandler.registerCarbonServerInfoService();
                        StartupOrderResolver.this.capabilityListenerTimer.cancel();
                        StartupOrderResolver.this.capabilityListenerTimer = null;
                        StartupOrderResolver.this.startupComponentManager = null;
                        StartupOrderResolver.this.stopCapabilityTrackers();
                        logger.debug("Complete - Startup Order Resolver.");
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    StartupOrderResolver.this.startupComponentManager.notifySatisfiableComponents();
                    return;
                }
            }
        }, capabilityListenerTimerDelay, capabilityListenerTimerPeriod);
    }

    private void schedulePendingCapabilityTimerTask() {
        CarbonConfiguration carbonConfiguration = this.carbonRuntime.getConfiguration();
        long pendingCapabilityTimerDelay = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getDelay();
        long pendingCapabilityTimerPeriod = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getPeriod();
        this.pendingCapabilityTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<StartupComponentManager> clazz = StartupComponentManager.class;
                synchronized (StartupComponentManager.class) {
                    if (StartupOrderResolver.this.startupComponentManager == null) {
                        logger.debug("StartupComponentManager is already disabled, therefore cancelling the pendingCapabilityTimer");
                        StartupOrderResolver.this.pendingCapabilityTimer.cancel();
                        StartupOrderResolver.this.pendingCapabilityTimer = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    List<StartupComponent> pendingComponents = StartupOrderResolver.this.startupComponentManager.getComponents(StartupComponent::isPending);
                    if (pendingComponents.size() == 0) {
                        logger.debug("All the RequiredCapabilityListeners are notified, therefore cancelling the pendingCapabilityTimer");
                        StartupOrderResolver.this.pendingCapabilityTimer.cancel();
                        StartupOrderResolver.this.pendingCapabilityTimer = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    StartupOrderResolverUtils.logPendingComponentDetails(logger, pendingComponents);
                    StartupOrderResolverUtils.logPendingRequiredCapabilityListenerServiceDetails(logger, StartupOrderResolver.this.startupComponentManager.getComponents(startupComponent -> startupComponent.getListener() == null));
                    StartupOrderResolverUtils.logPendingCapabilityProviderServiceDetails(logger, StartupOrderResolver.this.startupComponentManager.getPendingCapabilityProviders());
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, pendingCapabilityTimerDelay, pendingCapabilityTimerPeriod);
    }

    private void processServiceComponents(Map<String, List<ManifestElement>> groupedManifestElements) {
        groupedManifestElements.get("startup.listener").stream().map(StartupOrderResolverUtils::getStartupComponent).forEach(this.startupComponentManager::addStartupComponent);
    }

    private void processOSGiServices(List<ManifestElement> manifestElementList) {
        manifestElementList.stream().filter(StartupOrderResolverUtils.capabilityProviderElementPredicate.negate().and(StartupOrderResolverUtils.requiredCapabilityListenerElementPredicate.negate())).map(StartupOrderResolverUtils::getOSGiServiceCapabilities).flatMap(Collection::stream).forEach(serviceCapability -> {
            if (!serviceCapability.getRequiredByComponentNames().isEmpty()) {
                serviceCapability.getRequiredByComponentNames().forEach(componentName -> this.startupComponentManager.addRequiredOSGiServiceToComponent((String)componentName, serviceCapability.getName()));
            }
            this.startupComponentManager.addExpectedOrAvailableCapability((Capability)serviceCapability);
        });
    }

    private void processCapabilityProviders(List<ManifestElement> manifestElementList) {
        manifestElementList.stream().filter(StartupOrderResolverUtils.capabilityProviderElementPredicate).map(StartupOrderResolverUtils::getCapabilityProviderCapability).forEach(this.startupComponentManager::addExpectedOrAvailableCapabilityProvider);
    }

    private void startCapabilityTrackers() {
        this.osgiServiceTracker = new OSGiServiceCapabilityTracker(this.startupComponentManager);
        this.osgiServiceTracker.startTracker();
    }

    private void stopCapabilityTrackers() {
        if (this.osgiServiceTracker != null) {
            this.osgiServiceTracker.closeTracker();
            this.osgiServiceTracker = null;
        }
    }
}

