/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static <T> T createInstanceFromClass(Class<T> clazz, Class<?>[] constructorParameterTypes, Object ... constructorArguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> constructor = clazz.getConstructor(constructorParameterTypes);
        return constructor.newInstance(constructorArguments);
    }

    public static <T> Optional<Class<? extends T>> loadClassFromBundle(Class<? extends T> clazz) {
        String className = clazz.getName();
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        if (bundle != null) {
            try {
                return Optional.of(bundle.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                log.error("Class " + className + " do not exist in any bundle", e);
            }
        }
        return Optional.empty();
    }
}

