/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.jmx.security;

import java.util.Collections;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wso2.carbon.kernel.jmx.security.CarbonJMXCallbackHandler;

public class CarbonJMXAuthenticator
implements JMXAuthenticator {
    @Override
    public Subject authenticate(Object credentials) {
        if (credentials == null) {
            throw new SecurityException("Credentials required");
        }
        if (!(credentials instanceof String[])) {
            throw new SecurityException("Credentials should be String[]");
        }
        CarbonJMXCallbackHandler callbackHandler = new CarbonJMXCallbackHandler(credentials);
        try {
            LoginContext loginContext = new LoginContext("CarbonSecurityConfig", callbackHandler);
            loginContext.login();
            return new Subject(true, Collections.singleton(new JMXPrincipal(((String[])credentials)[0])), Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
        catch (LoginException e) {
            throw new SecurityException("Invalid credentials", e);
        }
    }
}

