/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.EntityBodyState;
import org.wso2.transport.http.netty.message.EntityCollector;

public class BlockingEntityCollector
implements EntityCollector {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEntityCollector.class);
    private int soTimeOut;
    private EntityBodyState state;
    private BlockingQueue<HttpContent> httpContentQueue;
    private Lock readWriteLock;
    private Condition readCondition;

    BlockingEntityCollector(int soTimeOut) {
        this.soTimeOut = soTimeOut;
        this.state = EntityBodyState.EXPECTING;
        this.readWriteLock = new ReentrantLock();
        this.httpContentQueue = new LinkedBlockingQueue<HttpContent>();
        this.readCondition = this.readWriteLock.newCondition();
    }

    @Override
    public void addHttpContent(HttpContent httpContent) {
        try {
            this.readWriteLock.lock();
            this.state = EntityBodyState.CONSUMABLE;
            this.httpContentQueue.add(httpContent);
            this.readCondition.signalAll();
        }
        catch (Exception e) {
            LOG.error("Cannot put content to queue", e);
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public void addMessageBody(ByteBuffer msgBody) {
        this.addHttpContent(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
    }

    @Override
    public HttpContent getHttpContent() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                this.waitForEntity();
                HttpContent httpContent = (HttpContent)this.httpContentQueue.poll();
                if (httpContent instanceof LastHttpContent) {
                    this.state = EntityBodyState.CONSUMED;
                    this.httpContentQueue.clear();
                }
                HttpContent httpContent2 = httpContent;
                return httpContent2;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving http content from queue", e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return null;
    }

    @Override
    public ByteBuf getMessageBody() {
        HttpContent httpContent = this.getHttpContent();
        if (httpContent != null) {
            return httpContent.content();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFullMessageLength() {
        long size = 0L;
        try {
            this.readWriteLock.lock();
            ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
            while (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                try {
                    this.waitForEntity();
                    HttpContent httpContent = (HttpContent)this.httpContentQueue.poll();
                    size += (long)httpContent.content().readableBytes();
                    contentList.add(httpContent);
                    if (!(httpContent instanceof LastHttpContent)) continue;
                    this.state = EntityBodyState.CONSUMED;
                }
                catch (InterruptedException e) {
                    LOG.warn("Error while getting full message length", e);
                }
            }
            this.httpContentQueue.addAll(contentList);
            this.state = EntityBodyState.CONSUMABLE;
        }
        catch (Exception e) {
            LOG.error("Error while retrieving http content length", e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countMessageLengthTill(long maxSize) {
        long size = 0L;
        try {
            this.readWriteLock.lock();
            ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
            while (this.state == EntityBodyState.CONSUMABLE || this.state == EntityBodyState.EXPECTING) {
                try {
                    this.waitForEntity();
                    HttpContent httpContent = (HttpContent)this.httpContentQueue.poll();
                    contentList.add(httpContent);
                    if ((size += (long)httpContent.content().readableBytes()) >= maxSize) break;
                    if (!(httpContent instanceof LastHttpContent)) continue;
                    this.state = EntityBodyState.CONSUMED;
                }
                catch (InterruptedException e) {
                    LOG.warn("Error while getting full message length", e);
                }
            }
            this.httpContentQueue.addAll(contentList);
            this.state = EntityBodyState.CONSUMABLE;
        }
        catch (Exception e) {
            LOG.error("Error while retrieving http content length", e);
        }
        finally {
            this.readWriteLock.unlock();
        }
        return size;
    }

    private void waitForEntity() throws InterruptedException {
        while (this.httpContentQueue.isEmpty() && this.readCondition.await(this.soTimeOut, TimeUnit.SECONDS)) {
        }
    }

    @Override
    public void waitAndReleaseAllEntities() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.CONSUMABLE) {
                boolean isEndOfMessageProcessed = false;
                while (!isEndOfMessageProcessed) {
                    try {
                        this.waitForEntity();
                        HttpContent httpContent = (HttpContent)this.httpContentQueue.poll();
                        if (httpContent instanceof LastHttpContent) {
                            isEndOfMessageProcessed = true;
                            this.state = EntityBodyState.CONSUMED;
                            this.httpContentQueue.clear();
                        }
                        httpContent.release();
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error while getting content from queue", e);
                    }
                }
            }
            this.state = EntityBodyState.EXPECTING;
        }
        catch (Exception e) {
            LOG.error("Error while waiting and releasing the content", e);
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.readWriteLock.lock();
            boolean bl = this.httpContentQueue.isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.unlock();
        }
    }

    @Override
    public void completeMessage() {
        try {
            this.readWriteLock.lock();
            if (this.state == EntityBodyState.EXPECTING) {
                this.addHttpContent(new DefaultLastHttpContent());
            }
        }
        finally {
            this.readWriteLock.unlock();
        }
    }
}

