/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.DefaultSessionManager;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.MicroservicesRegistry;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.SwaggerService;
import org.wso2.msf4j.internal.ClassComparator;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesLCException;
import org.wso2.msf4j.internal.router.MicroserviceMetadata;

public class MicroservicesRegistryImpl
implements MicroservicesRegistry {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRegistryImpl.class);
    private final Map<String, Object> services = new HashMap<String, Object>();
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private volatile MicroserviceMetadata metadata = new MicroserviceMetadata(Collections.emptyList());
    private Map<Class, ExceptionMapper> exceptionMappers = new TreeMap<Class, ExceptionMapper>(new ClassComparator());
    private SessionManager sessionManager = new DefaultSessionManager();

    public MicroservicesRegistryImpl() {
        ServiceLoader<SwaggerService> swaggerServices;
        Iterator<SwaggerService> iterator;
        if (DataHolder.getInstance().getBundleContext() == null && (iterator = (swaggerServices = ServiceLoader.load(SwaggerService.class)).iterator()).hasNext()) {
            SwaggerService swaggerService = iterator.next();
            swaggerService.init((MicroservicesRegistry)this);
            this.services.put("/swagger", swaggerService);
        }
    }

    public void addService(Object ... service) {
        for (Object svc2 : service) {
            this.services.put(svc2.getClass().getAnnotation(Path.class).value(), svc2);
        }
        this.updateMetadata();
        Arrays.stream(service).forEach(svc -> log.info("Added microservice: " + svc));
    }

    public void addService(String basePath, Object service) {
        this.services.put(basePath, service);
        this.metadata.addMicroserviceMetadata(service, basePath);
        log.info("Added microservice: " + service);
    }

    public Optional<Map.Entry<String, Object>> getServiceWithBasePath(String path) {
        return this.services.entrySet().stream().filter(svc -> ((String)svc.getKey()).equals(path)).findAny();
    }

    public void removeService(Object service) {
        this.services.remove(service);
        this.updateMetadata();
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (sessionManager == null) {
            throw new IllegalArgumentException("SessionManager cannot be null");
        }
        this.sessionManager = sessionManager;
    }

    public MicroserviceMetadata getMetadata() {
        return this.metadata;
    }

    public Set<Object> getHttpServices() {
        return Collections.unmodifiableSet(this.services.values().stream().collect(Collectors.toSet()));
    }

    public void addInterceptor(Interceptor ... interceptor) {
        Collections.addAll(this.interceptors, interceptor);
        this.updateMetadata();
    }

    public void addExceptionMapper(ExceptionMapper ... mapper) {
        Arrays.stream(mapper).forEach(em -> Arrays.stream(em.getClass().getMethods()).filter(method -> "toResponse".equals(method.getName()) && method.getParameterCount() == 1 && !Throwable.class.getName().equals(method.getParameterTypes()[0].getTypeName())).findAny().ifPresent(method -> {
            try {
                this.exceptionMappers.put(Class.forName(method.getParameterTypes()[0].getTypeName(), false, em.getClass().getClassLoader()), (ExceptionMapper)em);
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class", (Throwable)e);
            }
        }));
    }

    Optional<ExceptionMapper> getExceptionMapper(Throwable throwable) {
        return this.exceptionMappers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(throwable.getClass())).findFirst().flatMap(entry -> Optional.ofNullable(entry.getValue()));
    }

    public void removeExceptionMapper(ExceptionMapper em) {
        Arrays.stream(em.getClass().getMethods()).filter(method -> method.getName().equals("toResponse") && method.getParameterCount() == 1).findAny().ifPresent(method -> {
            try {
                this.exceptionMappers.remove(Class.forName(method.getGenericParameterTypes()[0].getTypeName(), false, em.getClass().getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                log.error("Could not load class", (Throwable)e);
            }
        });
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.updateMetadata();
    }

    public int getServiceCount() {
        return this.services.size();
    }

    private void updateMetadata() {
        this.metadata = new MicroserviceMetadata(Collections.unmodifiableCollection(this.services.values()));
    }

    public void initServices() {
        this.invokeLifecycleMethods(PostConstruct.class);
    }

    public void initService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PostConstruct.class);
    }

    public void preDestroyServices() {
        this.invokeLifecycleMethods(PreDestroy.class);
    }

    public void preDestroyService(Object httpService) {
        this.invokeLifecycleMethod(httpService, PreDestroy.class);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private void invokeLifecycleMethods(Class lcAnnotation) {
        this.services.values().stream().forEach(httpService -> this.invokeLifecycleMethod(httpService, lcAnnotation));
    }

    private void invokeLifecycleMethod(Object httpService, Class lcAnnotation) {
        Optional<Method> lcMethod = Optional.ofNullable(this.getLifecycleMethod(httpService, lcAnnotation));
        if (lcMethod.isPresent()) {
            try {
                lcMethod.get().invoke(httpService, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MicroservicesLCException("Exception occurs calling lifecycle method", e);
            }
        }
    }

    private Method getLifecycleMethod(Object httpService, Class lcAnnotation) {
        return Arrays.stream(httpService.getClass().getDeclaredMethods()).filter(m -> this.isValidLifecycleMethod(Optional.of(m), lcAnnotation)).findFirst().orElse(null);
    }

    private boolean isValidLifecycleMethod(Optional<Method> method, Class lcAnnotation) {
        return method.filter(m -> Modifier.isPublic(m.getModifiers()) && m.getAnnotation(lcAnnotation) != null).isPresent();
    }
}

