/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.deployer.internal;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.StartupServiceUtils;
import org.wso2.msf4j.MicroservicesRegistry;
import org.wso2.msf4j.deployer.internal.DataHolder;
import org.wso2.msf4j.deployer.internal.MicroservicesDeployer;

@Component(name="org.wso2.msf4j.deployer.internal.MSF4JDeployerSC", immediate=true, property={"componentName=wso2-microservices-deployer"})
public class MSF4JDeployerSC
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(MSF4JDeployerSC.class);
    private static final String CHANNEL_ID = "LISTENER_INTERFACE_ID";

    @Activate
    protected void start(BundleContext bundleContext) {
    }

    @Deactivate
    protected void stop() {
    }

    public void onAllRequiredCapabilitiesAvailable() {
        FrameworkUtil.getBundle(MSF4JDeployerSC.class).getBundleContext().registerService(Deployer.class, (Object)new MicroservicesDeployer(), null);
        log.debug("MicroservicesDeployer service is available");
    }

    @Reference(name="microservices-regitry", service=MicroservicesRegistry.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeMicroservicesRegistry")
    protected void addMicroservicesRegitry(MicroservicesRegistry registry, Map properties) {
        log.debug("MicroservicesRegistry get registered successfully.");
        DataHolder.getInstance().addMicroserviceRegistry(properties.get(CHANNEL_ID).toString(), registry);
        StartupServiceUtils.updateServiceCache((String)"wso2-microservices-deployer", MicroservicesRegistry.class);
    }

    protected void removeMicroservicesRegistry(MicroservicesRegistry microservicesRegistry, Map properties) {
        log.debug("MicroservicesRegistry get unregistered successfully.");
        DataHolder.getInstance().getMicroserviceRegistries().remove(properties.get(CHANNEL_ID).toString());
    }
}

