/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.PhysicalRowId;

final class Location {
    private long block;
    private short offset;

    Location(long block, short offset) {
        this.block = block;
        this.offset = offset;
    }

    Location(long blockOffset) {
        this.offset = (short)(blockOffset & 0xFFFFL);
        this.block = blockOffset >> 16;
    }

    Location(PhysicalRowId src) {
        this.block = src.getBlock();
        this.offset = src.getOffset();
    }

    long getBlock() {
        return this.block;
    }

    short getOffset() {
        return this.offset;
    }

    long toLong() {
        return (this.block << 16) + (long)this.offset;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        Location ol = (Location)o;
        return ol.block == this.block && ol.offset == this.offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Location ( ").append(this.block).append(" : ");
        sb.append(this.offset).append(" ) ");
        return sb.toString();
    }
}

