/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptedTimestampEncoder
implements Encoder,
EncoderFactory {
    public byte[] encode(Encodable encryptedTimestamp) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(this.encodeTimestamp((EncryptedTimeStamp)encryptedTimestamp));
        aos.close();
        return baos.toByteArray();
    }

    public Encoder getEncoder() {
        return new EncryptedTimestampEncoder();
    }

    private DERSequence encodeTimestamp(EncryptedTimeStamp encryptedTimestamp) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, KerberosTimeEncoder.encode(encryptedTimestamp.getTimeStamp())));
        if (encryptedTimestamp.getMicroSeconds() > 0) {
            sequence.add(new DERTaggedObject(1, DERInteger.valueOf(encryptedTimestamp.getMicroSeconds())));
        }
        return sequence;
    }
}

