/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapOperationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.message.internal.InternalBindResponse;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMechanismHandler
implements MechanismHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMechanismHandler.class);

    public SaslServer handleMechanism(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        BindOperationContext opContext = new BindOperationContext(null);
        opContext.setDn(bindRequest.getName());
        opContext.setCredentials(bindRequest.getCredentials());
        LdapProtocolUtils.setRequestControls(opContext, bindRequest);
        try {
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            adminSession.getDirectoryService().getOperationManager().bind(opContext);
            ldapSession.setCoreSession(opContext.getSession());
            InternalBindResponse response = (InternalBindResponse)bindRequest.getResultResponse();
            response.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            LdapProtocolUtils.setResponseControls(opContext, response);
            ldapSession.getIoSession().write(response);
            LOG.debug("Returned SUCCESS message: {}.", (Object)response);
        }
        catch (LdapException e) {
            ResultCodeEnum code = null;
            InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
            if (e instanceof LdapOperationException) {
                code = ((LdapOperationException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate(e, bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace(e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            DN name = null;
            if (e instanceof LdapAuthenticationException) {
                name = ((LdapAuthenticationException)e).getResolvedDn();
            }
            if (name != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(new DN(name));
            }
            result.setErrorMessage(msg);
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
        }
        return null;
    }

    public void init(LdapSession ldapSession) {
    }

    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

