/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.DefaultTransportMetadata;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.transport.socket.AbstractSocketSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioSocketSession
extends NioSession {
    static final TransportMetadata METADATA = new DefaultTransportMetadata("nio", "socket", false, true, InetSocketAddress.class, SocketSessionConfig.class, IoBuffer.class, FileRegion.class);
    private final IoService service;
    private final SocketSessionConfig config = new SessionConfigImpl();
    private final IoProcessor<NioSession> processor;
    private final IoFilterChain filterChain = new DefaultIoFilterChain(this);
    private final SocketChannel ch;
    private final IoHandler handler;
    private SelectionKey key;

    public NioSocketSession(IoService service, IoProcessor<NioSession> processor, SocketChannel ch) {
        this.service = service;
        this.processor = processor;
        this.ch = ch;
        this.handler = service.getHandler();
        this.config.setAll(service.getSessionConfig());
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    @Override
    public SocketSessionConfig getConfig() {
        return this.config;
    }

    @Override
    public IoProcessor<NioSession> getProcessor() {
        return this.processor;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return METADATA;
    }

    @Override
    SocketChannel getChannel() {
        return this.ch;
    }

    @Override
    SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.ch == null) {
            return null;
        }
        Socket socket = this.ch.socket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        if (this.ch == null) {
            return null;
        }
        Socket socket = this.ch.socket();
        if (socket == null) {
            return null;
        }
        return (InetSocketAddress)socket.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getServiceAddress() {
        return (InetSocketAddress)super.getServiceAddress();
    }

    private class SessionConfigImpl
    extends AbstractSocketSessionConfig {
        private SessionConfigImpl() {
        }

        public boolean isKeepAlive() {
            try {
                return NioSocketSession.this.ch.socket().getKeepAlive();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setKeepAlive(boolean on) {
            try {
                NioSocketSession.this.ch.socket().setKeepAlive(on);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public boolean isOobInline() {
            try {
                return NioSocketSession.this.ch.socket().getOOBInline();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setOobInline(boolean on) {
            try {
                NioSocketSession.this.ch.socket().setOOBInline(on);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public boolean isReuseAddress() {
            try {
                return NioSocketSession.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setReuseAddress(boolean on) {
            try {
                NioSocketSession.this.ch.socket().setReuseAddress(on);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getSoLinger() {
            try {
                return NioSocketSession.this.ch.socket().getSoLinger();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setSoLinger(int linger) {
            try {
                if (linger < 0) {
                    NioSocketSession.this.ch.socket().setSoLinger(false, 0);
                } else {
                    NioSocketSession.this.ch.socket().setSoLinger(true, linger);
                }
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public boolean isTcpNoDelay() {
            if (!NioSocketSession.this.isConnected()) {
                return false;
            }
            try {
                return NioSocketSession.this.ch.socket().getTcpNoDelay();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setTcpNoDelay(boolean on) {
            try {
                NioSocketSession.this.ch.socket().setTcpNoDelay(on);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getTrafficClass() {
            try {
                return NioSocketSession.this.ch.socket().getTrafficClass();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setTrafficClass(int tc) {
            try {
                NioSocketSession.this.ch.socket().setTrafficClass(tc);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getSendBufferSize() {
            try {
                return NioSocketSession.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setSendBufferSize(int size) {
            try {
                NioSocketSession.this.ch.socket().setSendBufferSize(size);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public int getReceiveBufferSize() {
            try {
                return NioSocketSession.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }

        public void setReceiveBufferSize(int size) {
            try {
                NioSocketSession.this.ch.socket().setReceiveBufferSize(size);
            }
            catch (SocketException e) {
                throw new RuntimeIoException(e);
            }
        }
    }
}

