/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.changelog.LogChange;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalAddRequest;
import org.apache.directory.shared.ldap.message.internal.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.internal.InternalDeleteRequest;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.internal.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.internal.InternalUnbindRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CoreSession {
    public DirectoryService getDirectoryService();

    public LdapPrincipal getAuthenticatedPrincipal();

    public LdapPrincipal getEffectivePrincipal();

    public boolean isConfidential();

    public boolean isAnonymous();

    public boolean isAdministrator();

    public boolean isAnAdministrator();

    public AuthenticationLevel getAuthenticationLevel();

    public Set<Control> getControls();

    public Set<OperationContext> getOutstandingOperations();

    public boolean isVirtual();

    public SocketAddress getClientAddress();

    public SocketAddress getServiceAddress();

    public void add(ServerEntry var1) throws Exception;

    public void add(ServerEntry var1, LogChange var2) throws Exception;

    public void add(ServerEntry var1, boolean var2) throws Exception;

    public void add(ServerEntry var1, boolean var2, LogChange var3) throws Exception;

    public void add(InternalAddRequest var1) throws Exception;

    public void add(InternalAddRequest var1, LogChange var2) throws Exception;

    public boolean compare(DN var1, String var2, Object var3) throws Exception;

    public boolean compare(DN var1, String var2, Object var3, boolean var4) throws Exception;

    public boolean compare(InternalCompareRequest var1) throws Exception;

    public void delete(DN var1) throws Exception;

    public void delete(DN var1, LogChange var2) throws Exception;

    public void delete(InternalDeleteRequest var1) throws Exception;

    public void delete(InternalDeleteRequest var1, LogChange var2) throws Exception;

    public void delete(DN var1, boolean var2) throws Exception;

    public void delete(DN var1, boolean var2, LogChange var3) throws Exception;

    public boolean exists(DN var1) throws Exception;

    public ClonedServerEntry lookup(DN var1) throws Exception;

    public ClonedServerEntry lookup(DN var1, String[] var2) throws Exception;

    public void modify(DN var1, List<Modification> var2) throws Exception;

    public void modify(DN var1, List<Modification> var2, LogChange var3) throws Exception;

    public void modify(DN var1, List<Modification> var2, boolean var3) throws Exception;

    public void modify(DN var1, List<Modification> var2, boolean var3, LogChange var4) throws Exception;

    public void modify(InternalModifyRequest var1) throws Exception;

    public void modify(InternalModifyRequest var1, LogChange var2) throws Exception;

    public void move(DN var1, DN var2) throws Exception;

    public void move(DN var1, DN var2, LogChange var3) throws Exception;

    public void move(DN var1, DN var2, boolean var3) throws Exception;

    public void move(DN var1, DN var2, boolean var3, LogChange var4) throws Exception;

    public void move(InternalModifyDnRequest var1) throws Exception;

    public void move(InternalModifyDnRequest var1, LogChange var2) throws Exception;

    public void moveAndRename(DN var1, DN var2, RDN var3, boolean var4) throws Exception;

    public void moveAndRename(DN var1, DN var2, RDN var3, boolean var4, LogChange var5) throws Exception;

    public void moveAndRename(DN var1, DN var2, RDN var3, boolean var4, boolean var5) throws Exception;

    public void moveAndRename(DN var1, DN var2, RDN var3, boolean var4, boolean var5, LogChange var6) throws Exception;

    public void moveAndRename(InternalModifyDnRequest var1) throws Exception;

    public void moveAndRename(InternalModifyDnRequest var1, LogChange var2) throws Exception;

    public void rename(DN var1, RDN var2, boolean var3) throws Exception;

    public void rename(DN var1, RDN var2, boolean var3, LogChange var4) throws Exception;

    public void rename(DN var1, RDN var2, boolean var3, boolean var4) throws Exception;

    public void rename(DN var1, RDN var2, boolean var3, boolean var4, LogChange var5) throws Exception;

    public void rename(InternalModifyDnRequest var1) throws Exception;

    public void rename(InternalModifyDnRequest var1, LogChange var2) throws Exception;

    public EntryFilteringCursor list(DN var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3) throws Exception;

    public EntryFilteringCursor list(DN var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3, long var4, int var6) throws Exception;

    public EntryFilteringCursor search(DN var1, String var2) throws Exception;

    public EntryFilteringCursor search(DN var1, String var2, boolean var3) throws Exception;

    public EntryFilteringCursor search(DN var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5) throws Exception;

    public EntryFilteringCursor search(DN var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5, long var6, int var8) throws Exception;

    public EntryFilteringCursor search(InternalSearchRequest var1) throws Exception;

    public void unbind() throws Exception;

    public void unbind(InternalUnbindRequest var1) throws Exception;
}

