/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.AbstractPartition;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.NullPartition;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.registries.synchronizers.RegistrySynchronizerAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPartition
extends AbstractPartition {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaPartition.class);
    private static final String ID = "schema";
    private Partition wrapped = new NullPartition();
    private SchemaManager schemaManager;
    private RegistrySynchronizerAdaptor synchronizer;
    private static DN schemaModificationDN;

    public void setWrappedPartition(Partition wrapped) {
        if (this.isInitialized()) {
            throw new IllegalStateException(I18n.err(I18n.ERR_429, new Object[0]));
        }
        this.wrapped = wrapped;
    }

    public Partition getWrappedPartition() {
        return this.wrapped;
    }

    public final String getId() {
        return ID;
    }

    public final void setId(String id) {
        LOG.warn("This partition's ID is fixed: {}", (Object)ID);
    }

    public final DN getSuffixDn() {
        return this.wrapped.getSuffixDn();
    }

    public final String getSuffix() {
        return "ou=schema";
    }

    public final void setSuffix(String suffix) {
        LOG.warn("This partition's suffix is fixed: {}", (Object)"ou=schema");
    }

    public void sync() throws Exception {
        this.wrapped.sync();
    }

    protected void doInit() throws Exception {
        this.wrapped.setId(ID);
        this.wrapped.setSuffix("ou=schema");
        this.wrapped.getSuffixDn().normalize(this.schemaManager.getNormalizerMapping());
        this.wrapped.setSchemaManager(this.schemaManager);
        try {
            this.wrapped.initialize();
            PartitionSchemaLoader partitionLoader = new PartitionSchemaLoader(this.wrapped, this.schemaManager);
            this.synchronizer = new RegistrySynchronizerAdaptor(this.schemaManager);
            if (this.wrapped instanceof NullPartition) {
                LOG.warn("BYPASSING CRITICAL SCHEMA PROCESSING CODE DURING HEAVY DEV.  PLEASE REMOVE THIS CONDITION BY USING A VALID SCHEMA PARTITION!!!");
                return;
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_90, new Object[0]), e);
            throw new RuntimeException(e);
        }
        schemaModificationDN = new DN("cn=schemaModifications,ou=schema");
        schemaModificationDN.normalize(this.schemaManager.getNormalizerMapping());
    }

    protected void doDestroy() {
        try {
            this.wrapped.destroy();
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_91, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    public void add(AddOperationContext opContext) throws Exception {
        this.synchronizer.add(opContext);
        this.wrapped.add(opContext);
        this.updateSchemaModificationAttributes(opContext);
    }

    public void bind(BindOperationContext opContext) throws Exception {
        this.wrapped.bind(opContext);
    }

    public void delete(DeleteOperationContext opContext) throws Exception {
        boolean cascade = opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        this.synchronizer.delete(opContext, cascade);
        this.wrapped.delete(opContext);
        this.updateSchemaModificationAttributes(opContext);
    }

    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        return this.wrapped.list(opContext);
    }

    public boolean hasEntry(EntryOperationContext entryContext) throws Exception {
        return this.wrapped.hasEntry(entryContext);
    }

    public void modify(ModifyOperationContext opContext) throws Exception {
        boolean cascade;
        ServerEntry targetEntry;
        boolean hasModification;
        ClonedServerEntry entry = opContext.getEntry();
        if (entry == null) {
            LookupOperationContext lookupCtx = new LookupOperationContext(opContext.getSession(), opContext.getDn());
            entry = this.wrapped.lookup(lookupCtx);
        }
        if (hasModification = this.synchronizer.modify(opContext, targetEntry = (ServerEntry)SchemaUtils.getTargetEntry(opContext.getModItems(), entry), cascade = opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1"))) {
            this.wrapped.modify(opContext);
        }
        if (!opContext.getDn().equals(schemaModificationDN)) {
            this.updateSchemaModificationAttributes(opContext);
        }
    }

    public void move(MoveOperationContext opContext) throws Exception {
        boolean cascade = opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        ClonedServerEntry entry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        this.synchronizer.move(opContext, entry, cascade);
        this.wrapped.move(opContext);
        this.updateSchemaModificationAttributes(opContext);
    }

    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        boolean cascade = opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        ClonedServerEntry entry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        this.synchronizer.moveAndRename(opContext, entry, cascade);
        this.wrapped.moveAndRename(opContext);
        this.updateSchemaModificationAttributes(opContext);
    }

    public void rename(RenameOperationContext opContext) throws Exception {
        boolean cascade = opContext.hasRequestControl("1.3.6.1.4.1.18060.0.0.1");
        this.synchronizer.rename(opContext, cascade);
        this.wrapped.rename(opContext);
        this.updateSchemaModificationAttributes(opContext);
    }

    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        return this.wrapped.search(opContext);
    }

    public void unbind(UnbindOperationContext opContext) throws Exception {
        this.wrapped.unbind(opContext);
    }

    public ClonedServerEntry lookup(LookupOperationContext lookupContext) throws Exception {
        return this.wrapped.lookup(lookupContext);
    }

    private void updateSchemaModificationAttributes(OperationContext opContext) throws Exception {
        String modifiersName = opContext.getSession().getEffectivePrincipal().getName();
        String modifyTimestamp = DateUtils.getGeneralizedTime();
        ArrayList<Modification> mods = new ArrayList<Modification>(2);
        mods.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultServerAttribute("schemaModifyTimestamp", this.schemaManager.lookupAttributeTypeRegistry("schemaModifyTimestamp"), modifyTimestamp)));
        mods.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, new DefaultServerAttribute("schemaModifiersName", this.schemaManager.lookupAttributeTypeRegistry("schemaModifiersName"), modifiersName)));
        opContext.modify(schemaModificationDN, mods, ByPassConstants.SCHEMA_MODIFICATION_ATTRIBUTES_UPDATE_BYPASS);
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public String toString() {
        return "Partition : schema";
    }
}

