/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.client.AbstractClientPoolFactory;
import org.wso2.carbon.databridge.agent.client.AbstractSecureClientPoolFactory;
import org.wso2.carbon.databridge.agent.client.ClientPool;
import org.wso2.carbon.databridge.agent.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;

public class DataEndpointAgent {
    private ArrayList<DataPublisher> dataPublishers = new ArrayList();
    private GenericKeyedObjectPool transportPool;
    private GenericKeyedObjectPool securedTransportPool;
    private AgentConfiguration agentConfiguration;

    public DataEndpointAgent(AgentConfiguration agentConfiguration) throws DataEndpointAgentConfigurationException {
        this.agentConfiguration = agentConfiguration;
        this.initialize();
    }

    private void initialize() throws DataEndpointAgentConfigurationException {
        try {
            DataEndpoint dataEndpoint = (DataEndpoint)DataEndpointAgent.class.getClassLoader().loadClass(this.agentConfiguration.getClassName()).newInstance();
            AbstractClientPoolFactory clientPoolFactory = (AbstractClientPoolFactory)DataEndpointAgent.class.getClassLoader().loadClass(dataEndpoint.getClientPoolFactoryClass()).newInstance();
            AbstractSecureClientPoolFactory secureClientPoolFactory = (AbstractSecureClientPoolFactory)DataEndpointAgent.class.getClassLoader().loadClass(dataEndpoint.getSecureClientPoolFactoryClass()).getConstructor(String.class, String.class).newInstance(this.agentConfiguration.getTrustStore(), this.agentConfiguration.getTrustStorePassword());
            ClientPool clientPool = new ClientPool();
            this.transportPool = clientPool.getClientPool(clientPoolFactory, this.agentConfiguration.getMaxTransportPoolSize(), this.agentConfiguration.getMaxIdleConnections(), true, (long)this.agentConfiguration.getEvictionTimePeriod(), (long)this.agentConfiguration.getMinIdleTimeInPool());
            this.securedTransportPool = clientPool.getClientPool(secureClientPoolFactory, this.agentConfiguration.getSecureMaxTransportPoolSize(), this.agentConfiguration.getSecureMaxIdleConnections(), true, (long)this.agentConfiguration.getSecureEvictionTimePeriod(), (long)this.agentConfiguration.getSecureMinIdleTimeInPool());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DataEndpointAgentConfigurationException("Error while creating the client pool " + e.getMessage(), e);
        }
    }

    public void addDataPublisher(DataPublisher dataPublisher) {
        this.dataPublishers.add(dataPublisher);
    }

    public AgentConfiguration getAgentConfiguration() {
        return this.agentConfiguration;
    }

    public GenericKeyedObjectPool getTransportPool() {
        return this.transportPool;
    }

    public GenericKeyedObjectPool getSecuredTransportPool() {
        return this.securedTransportPool;
    }

    public void shutDown(DataPublisher dataPublisher) {
        this.dataPublishers.remove(dataPublisher);
    }

    public DataEndpoint getNewDataEndpoint() throws DataEndpointException {
        try {
            return (DataEndpoint)DataEndpointAgent.class.getClassLoader().loadClass(this.getAgentConfiguration().getClassName()).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DataEndpointException("Error while instantiating the endpoint class for endpoint name " + this.getAgentConfiguration().getDataEndpointName() + ". " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new DataEndpointException("Class defined: " + this.getAgentConfiguration().getClassName() + " cannot be found for endpoint name " + this.getAgentConfiguration().getDataEndpointName() + ". " + e.getMessage(), e);
        }
    }

    public void shutDown() throws DataEndpointException {
        if (this.dataPublishers.isEmpty()) {
            try {
                this.transportPool.close();
                this.securedTransportPool.close();
            }
            catch (Exception e) {
                throw new DataEndpointException("Error while closing the transport pool", e);
            }
        }
    }
}

