/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ldap.server;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.apacheds.DirectoryServiceFactory;
import org.wso2.carbon.apacheds.KDCServer;
import org.wso2.carbon.apacheds.KdcConfiguration;
import org.wso2.carbon.apacheds.LDAPConfiguration;
import org.wso2.carbon.apacheds.LDAPServer;
import org.wso2.carbon.apacheds.PartitionInfo;
import org.wso2.carbon.apacheds.PartitionManager;
import org.wso2.carbon.ldap.server.configuration.LDAPConfigurationBuilder;
import org.wso2.carbon.ldap.server.exception.DirectoryServerException;
import org.wso2.carbon.ldap.server.tenant.LDAPTenantManagerService;
import org.wso2.carbon.ldap.server.util.EmbeddingLDAPException;
import org.wso2.carbon.user.core.tenant.LDAPTenantManager;

public class DirectoryActivator
implements BundleActivator {
    private final Logger log = Logger.getLogger(DirectoryActivator.class);
    private LDAPServer ldapServer;
    private KDCServer kdcServer;

    public void start(BundleContext bundleContext) {
        try {
            LDAPConfigurationBuilder configurationBuilder = new LDAPConfigurationBuilder(this.getLdapConfigurationFile());
            configurationBuilder.buildConfigurations();
            boolean embeddedLDAPEnabled = configurationBuilder.isEmbeddedLDAPEnabled();
            if (embeddedLDAPEnabled) {
                LDAPConfiguration ldapConfiguration = configurationBuilder.getLdapConfiguration();
                this.setSchemaLocation();
                this.setWorkingDirectory(ldapConfiguration);
                this.startLdapServer(ldapConfiguration);
                this.ldapServer.changeConnectionUserPassword(configurationBuilder.getConnectionPassword());
                PartitionManager partitionManager = this.ldapServer.getPartitionManager();
                PartitionInfo defaultPartitionInfo = configurationBuilder.getPartitionConfigurations();
                boolean defaultPartitionAlreadyExisted = partitionManager.partitionDirectoryExists(defaultPartitionInfo.getPartitionId());
                if (!defaultPartitionAlreadyExisted) {
                    partitionManager.addPartition(defaultPartitionInfo);
                    if (this.kdcServer == null) {
                        this.kdcServer = DirectoryServiceFactory.createKDCServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
                    }
                    this.kdcServer.kerberizePartition(configurationBuilder.getPartitionConfigurations(), this.ldapServer);
                } else {
                    partitionManager.initializeExistingPartition(defaultPartitionInfo);
                }
                if (configurationBuilder.isKdcEnabled()) {
                    this.startKDC(configurationBuilder.getKdcConfigurations());
                }
                LDAPTenantManagerService ldapTenantManager = new LDAPTenantManagerService(this.ldapServer.getPartitionManager());
                bundleContext.registerService(LDAPTenantManager.class.getName(), (Object)ldapTenantManager, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("apacheds-server component started.");
                }
            } else if (!embeddedLDAPEnabled) {
                this.log.info("Embedded LDAP is disabled.");
            }
        }
        catch (FileNotFoundException | DirectoryServerException | EmbeddingLDAPException e) {
            this.log.error("Could not start the embedded-ldap. ", e);
        }
    }

    private void setSchemaLocation() throws EmbeddingLDAPException {
        String schemaLocation = "repository" + File.separator + "data" + File.separator + "is-default-schema.zip";
        File dataDir = new File(this.getCarbonHome(), schemaLocation);
        System.setProperty("schema.zip.store.location", dataDir.getAbsolutePath());
    }

    private String getCarbonHome() throws EmbeddingLDAPException {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            String msg = "carbon.home property not set. Cannot find carbon home directory.";
            this.log.error(msg);
            throw new EmbeddingLDAPException(msg);
        }
        return carbonHome;
    }

    private File getLdapConfigurationFile() throws EmbeddingLDAPException {
        String configurationFilePath = "repository" + File.separator + "conf" + File.separator + "identity" + File.separator + "embedded-ldap.xml";
        return new File(this.getCarbonHome(), configurationFilePath);
    }

    private void setWorkingDirectory(LDAPConfiguration ldapConfiguration) throws EmbeddingLDAPException {
        if (".".equals(ldapConfiguration.getWorkingDirectory())) {
            File dataDir = new File(this.getCarbonHome(), "repository/data");
            if (!dataDir.exists() && !dataDir.mkdir()) {
                String msg = "Unable to create data directory at " + dataDir.getAbsolutePath();
                this.log.error(msg);
                throw new EmbeddingLDAPException(msg);
            }
            File bundleDataDir = new File(dataDir, "org.wso2.carbon.directory");
            if (!bundleDataDir.exists() && !bundleDataDir.mkdirs()) {
                String msg = "Unable to create schema data directory at " + bundleDataDir.getAbsolutePath();
                this.log.error(msg);
                throw new EmbeddingLDAPException(msg);
            }
            ldapConfiguration.setWorkingDirectory(bundleDataDir.getAbsolutePath());
        }
    }

    private void startLdapServer(LDAPConfiguration ldapConfiguration) throws DirectoryServerException {
        this.ldapServer = DirectoryServiceFactory.createLDAPServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initializing Directory Server with working directory " + ldapConfiguration.getWorkingDirectory() + " and port " + ldapConfiguration.getLdapPort());
        }
        this.ldapServer.init(ldapConfiguration);
        this.ldapServer.start();
    }

    private void startKDC(KdcConfiguration kdcConfiguration) throws DirectoryServerException {
        if (this.kdcServer == null) {
            this.kdcServer = DirectoryServiceFactory.createKDCServer(DirectoryServiceFactory.LDAPServerType.APACHE_DIRECTORY_SERVICE);
        }
        this.kdcServer.init(kdcConfiguration, this.ldapServer);
        this.kdcServer.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.kdcServer != null) {
            this.kdcServer.stop();
        }
        if (this.ldapServer != null) {
            this.ldapServer.stop();
        }
    }
}

