/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config;

import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.config.model.MetricsLevelConfig;
import org.wso2.carbon.metrics.core.utils.Utils;

public final class MetricsLevelConfigBuilder {
    private static final String METRICS_ROOT_LEVEL = "metrics.rootLevel";
    private static final String METRIC_LEVEL_PREFIX = "metric.level.";

    public static MetricsLevelConfig build() {
        MetricsLevelConfig metricsLevelConfig = new MetricsLevelConfig();
        Optional<Properties> propertiesOptional = Utils.loadProperties("metrics.level.conf", "metrics.properties");
        propertiesOptional.ifPresent(properties -> {
            metricsLevelConfig.setRootLevel(Level.toLevel(properties.getProperty(METRICS_ROOT_LEVEL, Level.OFF.name()).trim(), Level.OFF));
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!key.startsWith(METRIC_LEVEL_PREFIX)) continue;
                String metricName = key.substring(METRIC_LEVEL_PREFIX.length());
                metricsLevelConfig.setLevel(metricName, Level.toLevel(properties.getProperty(key), Level.OFF));
            }
        });
        return metricsLevelConfig;
    }
}

