/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Gauge;
import org.wso2.carbon.metrics.core.Histogram;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.Metric;
import org.wso2.carbon.metrics.core.MetricNotFoundException;
import org.wso2.carbon.metrics.core.Timer;
import org.wso2.carbon.metrics.core.config.model.MetricsLevelConfig;
import org.wso2.carbon.metrics.core.impl.AbstractMetric;
import org.wso2.carbon.metrics.core.impl.CachedGaugeImpl;
import org.wso2.carbon.metrics.core.impl.CounterCollection;
import org.wso2.carbon.metrics.core.impl.CounterImpl;
import org.wso2.carbon.metrics.core.impl.GaugeImpl;
import org.wso2.carbon.metrics.core.impl.HistogramCollection;
import org.wso2.carbon.metrics.core.impl.HistogramImpl;
import org.wso2.carbon.metrics.core.impl.MeterCollection;
import org.wso2.carbon.metrics.core.impl.MeterImpl;
import org.wso2.carbon.metrics.core.impl.TimerImpl;
import org.wso2.carbon.metrics.core.impl.listener.EnabledStatusChangeListener;
import org.wso2.carbon.metrics.core.impl.listener.MetricLevelChangeListener;
import org.wso2.carbon.metrics.core.impl.listener.RootLevelChangeListener;
import org.wso2.carbon.metrics.core.metric.ClassLoadingGaugeSet;
import org.wso2.carbon.metrics.core.metric.OperatingSystemMetricSet;

public final class MetricManager {
    private final ConcurrentMap<String, MetricWrapper> metricsMap = new ConcurrentHashMap<String, MetricWrapper>();
    private final ConcurrentMap<String, Metric> metricCollectionsMap = new ConcurrentHashMap<String, Metric>();
    private boolean enabled;
    private final MetricRegistry metricRegistry;
    private static final String ROOT_METRIC_NAME = "";
    private static final String METRIC_PATH_DELIMITER = ".";
    private static final String METRIC_PATH_DELIMITER_REGEX = "\\.";
    private final MetricsLevelConfig metricsLevelConfig;
    private final MetricFilter enabledMetricFilter = new EnabledMetricFilter();
    private static final Pattern METRIC_AGGREGATE_ANNOTATION_PATTERN = Pattern.compile("^(.+)\\[\\+\\]$");
    private final List<EnabledStatusChangeListener> enabledStatusChangeListeners;
    private final List<RootLevelChangeListener> rootLevelChangeListeners;
    private final List<MetricLevelChangeListener> metricLevelChangeListeners;
    private final MetricBuilder<MeterImpl> meterBuilder = new MetricBuilder<MeterImpl>(){

        @Override
        public MeterImpl createMetric(String name, Level level) {
            return new MeterImpl(name, level, MetricManager.this.metricRegistry.meter(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return MeterImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<CounterImpl> counterBuilder = new MetricBuilder<CounterImpl>(){

        @Override
        public CounterImpl createMetric(String name, Level level) {
            return new CounterImpl(name, level, MetricManager.this.metricRegistry.counter(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return CounterImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<TimerImpl> timerBuilder = new MetricBuilder<TimerImpl>(){

        @Override
        public TimerImpl createMetric(String name, Level level) {
            return new TimerImpl(name, level, MetricManager.this.metricRegistry.timer(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return TimerImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<HistogramImpl> histogramBuilder = new MetricBuilder<HistogramImpl>(){

        @Override
        public HistogramImpl createMetric(String name, Level level) {
            return new HistogramImpl(name, level, MetricManager.this.metricRegistry.histogram(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return HistogramImpl.class.isInstance(metric);
        }
    };
    private final MetricCollectionBuilder<Counter, CounterImpl> counterCollectionBuilder = new MetricCollectionBuilder<Counter, CounterImpl>(){

        @Override
        public Counter createMetricCollection(String[] names, Level[] levels, MetricBuilder<CounterImpl> metricBuilder) {
            Counter parentCounter = (Counter)((Object)MetricManager.this.getOrCreateMetric(names[0], levels[0], metricBuilder));
            ArrayList<Counter> childCounters = new ArrayList<Counter>(names.length - 1);
            for (int i = 1; i < names.length; ++i) {
                childCounters.add((Counter)((Object)MetricManager.this.getOrCreateMetric(names[i], levels[i], metricBuilder)));
            }
            return new CounterCollection(parentCounter, childCounters);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Counter.class.isInstance(metric);
        }
    };
    private final MetricCollectionBuilder<Meter, MeterImpl> meterCollectionBuilder = new MetricCollectionBuilder<Meter, MeterImpl>(){

        @Override
        public Meter createMetricCollection(String[] names, Level[] levels, MetricBuilder<MeterImpl> metricBuilder) {
            Meter parentMeter = (Meter)((Object)MetricManager.this.getOrCreateMetric(names[0], levels[0], metricBuilder));
            ArrayList<Meter> childMeters = new ArrayList<Meter>(names.length - 1);
            for (int i = 1; i < names.length; ++i) {
                childMeters.add((Meter)((Object)MetricManager.this.getOrCreateMetric(names[i], levels[i], metricBuilder)));
            }
            return new MeterCollection(parentMeter, childMeters);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Meter.class.isInstance(metric);
        }
    };
    private final MetricCollectionBuilder<Histogram, HistogramImpl> histogramCollectionBuilder = new MetricCollectionBuilder<Histogram, HistogramImpl>(){

        @Override
        public Histogram createMetricCollection(String[] names, Level[] levels, MetricBuilder<HistogramImpl> metricBuilder) {
            Histogram parentHistogram = (Histogram)((Object)MetricManager.this.getOrCreateMetric(names[0], levels[0], metricBuilder));
            ArrayList<Histogram> childHistograms = new ArrayList<Histogram>(names.length - 1);
            for (int i = 1; i < names.length; ++i) {
                childHistograms.add((Histogram)((Object)MetricManager.this.getOrCreateMetric(names[i], levels[i], metricBuilder)));
            }
            return new HistogramCollection(parentHistogram, childHistograms);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Histogram.class.isInstance(metric);
        }
    };

    public MetricManager(MetricRegistry metricRegistry, MetricsLevelConfig metricsLevelConfig) {
        this.metricRegistry = metricRegistry;
        this.metricsLevelConfig = metricsLevelConfig;
        this.enabledStatusChangeListeners = new CopyOnWriteArrayList<EnabledStatusChangeListener>();
        this.rootLevelChangeListeners = new CopyOnWriteArrayList<RootLevelChangeListener>();
        this.metricLevelChangeListeners = new CopyOnWriteArrayList<MetricLevelChangeListener>();
        this.registerJVMMetrics();
        this.addEnabledStatusChangeListener(enabledStatus -> this.notifyEnabledStatus());
        this.addRootLevelChangeListener((oldLevel, newLevel) -> this.notifyEnabledStatus());
        this.addMetricLevelChangeListener((metric, oldLevel, newLevel) -> metric.setEnabled(this.isMetricEnabled(metric.getName(), metric.getLevel(), newLevel, false)));
    }

    MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    MetricFilter getEnabledMetricFilter() {
        return this.enabledMetricFilter;
    }

    public void addEnabledStatusChangeListener(EnabledStatusChangeListener listener) {
        this.enabledStatusChangeListeners.add(listener);
    }

    public void removeEnabledStatusChangeListener(EnabledStatusChangeListener listener) {
        this.enabledStatusChangeListeners.remove(listener);
    }

    public void addRootLevelChangeListener(RootLevelChangeListener listener) {
        this.rootLevelChangeListeners.add(listener);
    }

    public void removeRootLevelChangeListener(RootLevelChangeListener listener) {
        this.rootLevelChangeListeners.remove(listener);
    }

    public void addMetricLevelChangeListener(MetricLevelChangeListener listener) {
        this.metricLevelChangeListeners.add(listener);
    }

    public void removeMetricLevelChangeListener(MetricLevelChangeListener listener) {
        this.metricLevelChangeListeners.remove(listener);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        boolean changed = this.enabled != enabled;
        this.enabled = enabled;
        if (changed) {
            this.enabledStatusChangeListeners.forEach(listener -> listener.stateChanged(enabled));
        }
    }

    private void notifyEnabledStatus() {
        this.metricsMap.values().forEach(metricWrapper -> {
            AbstractMetric metric = ((MetricWrapper)metricWrapper).metric;
            metric.setEnabled(this.isMetricEnabled(((MetricWrapper)metricWrapper).name, metric.getLevel(), this.metricsLevelConfig.getLevel(metric.getName()), false));
        });
    }

    public Level getMetricLevel(String name) {
        if (!this.metricsMap.containsKey(name)) {
            throw new IllegalArgumentException("Invalid Metric Name");
        }
        return this.metricsLevelConfig.getLevel(name);
    }

    public void setMetricLevel(String name, Level level) {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper == null) {
            throw new IllegalArgumentException("Invalid Metric Name");
        }
        Level currentLevel = this.metricsLevelConfig.getLevel(name);
        if (currentLevel == null || !currentLevel.equals(level)) {
            this.metricsLevelConfig.setLevel(name, level);
            AbstractMetric metric = metricWrapper.metric;
            this.metricLevelChangeListeners.forEach(listener -> listener.levelChanged(metric, currentLevel, level));
        }
    }

    public Level getRootLevel() {
        return this.metricsLevelConfig.getRootLevel();
    }

    public void setRootLevel(Level level) {
        Level oldLevel = this.metricsLevelConfig.getRootLevel();
        boolean changed = !oldLevel.equals(level);
        this.metricsLevelConfig.setRootLevel(level);
        if (changed) {
            this.rootLevelChangeListeners.forEach(listener -> listener.levelChanged(oldLevel, level));
        }
    }

    private boolean isMetricEnabled(String name, Level metricLevel, Level configLevel, boolean getFromCache) {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (!getFromCache || metricWrapper.enabled == null) {
            metricWrapper.enabled = this.isMetricEnabledBasedOnHierarchyLevel(name, metricLevel, configLevel);
        }
        return metricWrapper.enabled;
    }

    private boolean isMetricEnabledBasedOnHierarchyLevel(String name, Level metricLevel, Level configLevel) {
        String parentName;
        if (configLevel != null) {
            return this.enabled && configLevel.compareTo(metricLevel) >= 0 && configLevel.compareTo(Level.OFF) > 0;
        }
        int index = name.lastIndexOf(METRIC_PATH_DELIMITER);
        if (index != -1) {
            parentName = name.substring(0, index);
            configLevel = this.metricsLevelConfig.getLevel(parentName);
        } else {
            parentName = ROOT_METRIC_NAME;
            configLevel = this.metricsLevelConfig.getRootLevel();
        }
        return this.isMetricEnabledBasedOnHierarchyLevel(parentName, metricLevel, configLevel);
    }

    private <T extends Metric> T getMetric(String name, Class metricClass) throws MetricNotFoundException {
        Metric metric = null;
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper != null) {
            metric = metricWrapper.metric;
        }
        if (metric == null) {
            metric = (Metric)this.metricCollectionsMap.get(name);
        }
        if (metric == null) {
            throw new MetricNotFoundException("Metric \"" + name + "\" is not found");
        }
        if (!metricClass.isInstance(metric)) {
            throw new IllegalArgumentException("The name \"" + name + "\" is used for a different type of metric");
        }
        return (T)metric;
    }

    private <T extends AbstractMetric> T getOrCreateMetric(String name, Level level, MetricBuilder<T> metricBuilder) {
        if (this.isAnnotated(name)) {
            throw new IllegalArgumentException("The metric name should not be annotated");
        }
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper != null && metricWrapper.metric != null) {
            AbstractMetric metric = metricWrapper.metric;
            if (metricBuilder.isInstance(metric)) {
                if (level.equals(metricWrapper.level)) {
                    return (T)metric;
                }
                throw new IllegalArgumentException(name + " is already used with a different level");
            }
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        boolean enabled = this.isMetricEnabledBasedOnHierarchyLevel(name, level, this.metricsLevelConfig.getLevel(name));
        metricWrapper = new MetricWrapper(name, level, enabled);
        this.metricsMap.put(name, metricWrapper);
        T newMetric = metricBuilder.createMetric(name, level);
        metricWrapper.metric = newMetric;
        ((AbstractMetric)newMetric).setEnabled(enabled);
        return newMetric;
    }

    private <T extends AbstractMetric, M extends Metric> M getOrCreateMetricCollection(String name, Level[] levels, MetricBuilder<T> metricBuilder, MetricCollectionBuilder<M, T> metricCollectionBuilder) {
        String[] metricNames = this.getMetricHierarchyNames(name);
        if (levels.length != metricNames.length) {
            throw new IllegalArgumentException("The metric levels don't match the annotated name");
        }
        Metric metricCollection = (Metric)this.metricCollectionsMap.get(name);
        if (metricCollection != null && !metricCollectionBuilder.isInstance(metricCollection)) {
            throw new IllegalArgumentException(name + " is already used for a different type of metric collection");
        }
        metricCollection = metricCollectionBuilder.createMetricCollection(metricNames, levels, metricBuilder);
        this.metricCollectionsMap.put(name, metricCollection);
        return (M)metricCollection;
    }

    private boolean isAnnotated(String name) {
        String[] nameParts;
        for (String namePart : nameParts = name.split(METRIC_PATH_DELIMITER_REGEX)) {
            Matcher matcher = METRIC_AGGREGATE_ANNOTATION_PATTERN.matcher(namePart);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String[] getMetricHierarchyNames(String name) {
        String[] nameParts = name.split(METRIC_PATH_DELIMITER_REGEX);
        if (nameParts.length < 3) {
            throw new IllegalArgumentException("At least three parts should be there in the annotated metric name \"" + name + "\".");
        }
        for (int i = 1; i <= 2; ++i) {
            if (!METRIC_AGGREGATE_ANNOTATION_PATTERN.matcher(nameParts[nameParts.length - i]).find()) continue;
            throw new IllegalArgumentException("The last two parts of the metric name \"" + name + "\" should not be annotated.");
        }
        String metricName = nameParts[nameParts.length - 1];
        StringBuilder parentNameBuilder = new StringBuilder();
        ArrayList<String> childNames = new ArrayList<String>();
        for (int i = 0; i < nameParts.length; ++i) {
            Matcher matcher = METRIC_AGGREGATE_ANNOTATION_PATTERN.matcher(nameParts[i]);
            if (i > 0) {
                parentNameBuilder.append(METRIC_PATH_DELIMITER);
            }
            if (matcher.find()) {
                parentNameBuilder.append(matcher.group(1));
                childNames.add(String.format("%s.%s", parentNameBuilder.toString(), metricName));
                continue;
            }
            parentNameBuilder.append(nameParts[i]);
        }
        String parentName = parentNameBuilder.toString();
        String[] names = new String[childNames.size() + 1];
        names[0] = parentName;
        for (int i = 0; i < childNames.size(); ++i) {
            names[i + 1] = (String)childNames.get(i);
        }
        return names;
    }

    private Level[] levels(Level level, Level[] levels) {
        Level[] levelArray = new Level[levels.length + 1];
        System.arraycopy(levels, 0, levelArray, 1, levels.length);
        levelArray[0] = level;
        return levelArray;
    }

    public Meter meter(String name) throws MetricNotFoundException {
        return (Meter)this.getMetric(name, Meter.class);
    }

    public Meter meter(String name, Level level, Level ... levels) {
        if (levels.length == 0) {
            return this.getOrCreateMetric(name, level, this.meterBuilder);
        }
        return this.getOrCreateMetricCollection(name, this.levels(level, levels), this.meterBuilder, this.meterCollectionBuilder);
    }

    public Counter counter(String name) throws MetricNotFoundException {
        return (Counter)this.getMetric(name, Counter.class);
    }

    public Counter counter(String name, Level level, Level ... levels) {
        if (levels.length == 0) {
            return this.getOrCreateMetric(name, level, this.counterBuilder);
        }
        return this.getOrCreateMetricCollection(name, this.levels(level, levels), this.counterBuilder, this.counterCollectionBuilder);
    }

    public Timer timer(String name) throws MetricNotFoundException {
        return (Timer)this.getMetric(name, Timer.class);
    }

    public Timer timer(String name, Level level) {
        return this.getOrCreateMetric(name, level, this.timerBuilder);
    }

    public Histogram histogram(String name) throws MetricNotFoundException {
        return (Histogram)this.getMetric(name, Histogram.class);
    }

    public Histogram histogram(String name, Level level, Level ... levels) {
        if (levels.length == 0) {
            return this.getOrCreateMetric(name, level, this.histogramBuilder);
        }
        return this.getOrCreateMetricCollection(name, this.levels(level, levels), this.histogramBuilder, this.histogramCollectionBuilder);
    }

    public <T> void gauge(String name, Level level, Gauge<T> gauge) {
        this.getOrCreateMetric(name, level, new GaugeBuilder<T>(gauge));
    }

    public <T> void cachedGauge(String name, Level level, long timeout, TimeUnit timeoutUnit, Gauge<T> gauge) {
        this.getOrCreateMetric(name, level, new CachedGaugeBuilder<T>(gauge, timeout, timeoutUnit));
    }

    public boolean remove(String name) {
        boolean removed;
        if (this.isAnnotated(name)) {
            String[] metricNames;
            Metric metric = (Metric)this.metricCollectionsMap.remove(name);
            removed = metric != null;
            for (String metricName : metricNames = this.getMetricHierarchyNames(name)) {
                removed = this.removeMetric(metricName) || removed;
            }
        } else {
            removed = this.removeMetric(name);
        }
        return removed;
    }

    private boolean removeMetric(String name) {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.remove(name);
        if (metricWrapper != null) {
            return this.metricRegistry.remove(name);
        }
        return false;
    }

    public long getMetricsCount() {
        return this.metricsMap.size();
    }

    public long getEnabledMetricsCount() {
        return this.metricsMap.values().stream().filter(metricWrapper -> ((MetricWrapper)metricWrapper).enabled).count();
    }

    public long getMetricCollectionsCount() {
        return this.metricCollectionsMap.size();
    }

    private void registerJVMMetrics() {
        this.registerAllJVMMetrics(Level.INFO, "jvm.memory", new MemoryUsageGaugeSet());
        this.registerAllJVMMetrics(Level.INFO, "jvm.os", new OperatingSystemMetricSet());
        this.registerAllJVMMetrics(Level.INFO, "jvm.class-loading", new ClassLoadingGaugeSet());
        this.registerAllJVMMetrics(Level.DEBUG, "jvm.gc", new GarbageCollectorMetricSet());
        this.registerAllJVMMetrics(Level.DEBUG, "jvm.threads", new ThreadStatesGaugeSet());
        this.registerAllJVMMetrics(Level.TRACE, "jvm.buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
    }

    private void registerAllJVMMetrics(Level level, String prefix, MetricSet metrics) throws IllegalArgumentException {
        metrics.getMetrics().entrySet().stream().filter(entry -> this.filterJVMMetric((String)entry.getKey())).forEach(entry -> {
            String name = MetricRegistry.name(prefix, (String)entry.getKey());
            com.codahale.metrics.Metric metric = (com.codahale.metrics.Metric)entry.getValue();
            com.codahale.metrics.Gauge gauge = (com.codahale.metrics.Gauge)metric;
            this.gauge(name, level, new JVMGaugeWrapper(gauge));
        });
    }

    private boolean filterJVMMetric(String name) {
        return !"deadlocks".equals(name);
    }

    private class EnabledMetricFilter
    implements MetricFilter {
        private EnabledMetricFilter() {
        }

        @Override
        public boolean matches(String name, com.codahale.metrics.Metric metric) {
            MetricWrapper metricWrapper = (MetricWrapper)MetricManager.this.metricsMap.get(name);
            return MetricManager.this.isMetricEnabled(metricWrapper.name, metricWrapper.level, MetricManager.this.metricsLevelConfig.getLevel(name), true);
        }
    }

    private static class JVMGaugeWrapper
    implements Gauge<Object> {
        private final com.codahale.metrics.Gauge<?> gauge;

        private JVMGaugeWrapper(com.codahale.metrics.Gauge<?> gauge) {
            this.gauge = gauge;
        }

        @Override
        public Object getValue() {
            return this.gauge.getValue();
        }
    }

    private static interface MetricCollectionBuilder<T extends Metric, M extends AbstractMetric> {
        public T createMetricCollection(String[] var1, Level[] var2, MetricBuilder<M> var3);

        public boolean isInstance(Metric var1);
    }

    private class CachedGaugeBuilder<T>
    implements MetricBuilder<CachedGaugeImpl<T>> {
        private final Gauge<T> gauge;
        private final long timeout;
        private final TimeUnit timeoutUnit;

        CachedGaugeBuilder(Gauge<T> gauge, long timeout, TimeUnit timeoutUnit) {
            this.gauge = gauge;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
        }

        @Override
        public CachedGaugeImpl<T> createMetric(String name, Level level) {
            CachedGaugeImpl<T> gaugeImpl = new CachedGaugeImpl<T>(name, level, this.timeout, this.timeoutUnit, this.gauge);
            MetricManager.this.metricRegistry.register(name, gaugeImpl);
            return gaugeImpl;
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return CachedGaugeImpl.class.isInstance(metric);
        }
    }

    private class GaugeBuilder<T>
    implements MetricBuilder<GaugeImpl<T>> {
        private final Gauge<T> gauge;

        GaugeBuilder(Gauge<T> gauge) {
            this.gauge = gauge;
        }

        @Override
        public GaugeImpl<T> createMetric(String name, Level level) {
            GaugeImpl<T> gaugeImpl = new GaugeImpl<T>(name, level, this.gauge);
            MetricManager.this.metricRegistry.register(name, gaugeImpl);
            return gaugeImpl;
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return GaugeImpl.class.isInstance(metric);
        }
    }

    private static interface MetricBuilder<T extends AbstractMetric> {
        public T createMetric(String var1, Level var2);

        public boolean isInstance(AbstractMetric var1);
    }

    private static class MetricWrapper {
        private final Level level;
        private final String name;
        private Boolean enabled;
        private AbstractMetric metric;

        private MetricWrapper(String name, Level level, Boolean enabled) {
            this.name = name;
            this.level = level;
            this.enabled = enabled;
        }
    }
}

