/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListenerConfiguration {
    public static final String DEFAULT_KEY = "netty";
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String host;
    @XmlAttribute(required=true)
    private int port;
    @XmlAttribute
    private boolean bindOnStartup = true;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePass;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters = this.getDefaultParameters();

    public static ListenerConfiguration getDefault() {
        ListenerConfiguration defaultConfig = new ListenerConfiguration(DEFAULT_KEY, "0.0.0.0", 8080);
        return defaultConfig;
    }

    public ListenerConfiguration() {
    }

    public ListenerConfiguration(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBindOnStartup() {
        return this.bindOnStartup;
    }

    public void setBindOnStartup(boolean bindOnStartup) {
        this.bindOnStartup = bindOnStartup;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForListener(this.certPass, this.keyStorePass, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters);
    }

    private List<Parameter> getDefaultParameters() {
        ArrayList<Parameter> defaultParams = new ArrayList<Parameter>();
        return defaultParams;
    }
}

