/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;

public class PoolableTargetChannelFactory
implements PoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolableTargetChannelFactory.class);
    private EventLoopGroup eventLoopGroup;
    private Class eventLoopClass;
    private HttpRoute httpRoute;
    private SenderConfiguration senderConfiguration;

    public PoolableTargetChannelFactory(HttpRoute httpRoute, EventLoopGroup eventLoopGroup, Class eventLoopClass, SenderConfiguration senderConfiguration) {
        this.eventLoopGroup = eventLoopGroup;
        this.eventLoopClass = eventLoopClass;
        this.httpRoute = httpRoute;
        this.senderConfiguration = senderConfiguration;
    }

    @Override
    public Object makeObject() throws Exception {
        TargetChannel targetChannel = new TargetChannel();
        ChannelFuture channelFuture = ChannelUtils.getNewChannelFuture(targetChannel, this.eventLoopGroup, this.eventLoopClass, this.httpRoute, this.senderConfiguration);
        Channel channel = ChannelUtils.openChannel(channelFuture, this.httpRoute);
        log.debug("Created channel: {}", (Object)channel);
        targetChannel.setChannel(channel);
        return targetChannel;
    }

    @Override
    public void destroyObject(Object o) throws Exception {
        log.debug("Destroying channel: {}", o);
        if (((TargetChannel)o).getChannel().isOpen()) {
            ((TargetChannel)o).getChannel().close();
        }
    }

    @Override
    public boolean validateObject(Object o) {
        boolean answer = ((TargetChannel)o).getChannel().isActive();
        log.debug("Validating channel: {} -> {}", o, (Object)answer);
        return answer;
    }

    @Override
    public void activateObject(Object o) throws Exception {
    }

    @Override
    public void passivateObject(Object o) throws Exception {
    }
}

