/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.websocket;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.websocket.WebSocketEndpoint;

@Component(name="org.wso2.msf4j.internal.websocket.WebSocketServerSC", immediate=true, property={"componentName=wso2-websocket-server"})
public class WebSocketServerSC
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerSC.class);
    private EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();

    @Activate
    protected void start(BundleContext bundleContext) {
        if (log.isDebugEnabled()) {
            log.debug("Endpoint Activated.");
        }
    }

    @Reference(name="websocketEndpoint", service=WebSocketEndpoint.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeEndpoint")
    protected void addEndpoint(WebSocketEndpoint endpoint) {
        this.endpointsRegistry.addEndpoint(endpoint);
    }

    protected void removeEndpoint(WebSocketEndpoint endpoint) {
        this.endpointsRegistry.removeEndpoint(endpoint);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        DataHolder.getInstance().getBundleContext().registerService(WebSocketServerSC.class, this, null);
        log.info("All required capabilities are available of WebSocket service component is available.");
    }
}

