/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.config.model.ScheduledReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.reporter.impl.ConsoleReporter;

public class ConsoleReporterConfig
extends ScheduledReporterConfig
implements ReporterBuilder<ConsoleReporter> {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleReporterConfig.class);

    public ConsoleReporterConfig() {
        super("Console");
    }

    @Override
    public Optional<ConsoleReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating Console Reporter for Metrics with %d seconds polling period", this.getPollingPeriod()));
        }
        return Optional.of(new ConsoleReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), this.getPollingPeriod()));
    }
}

