/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.HttpHeaders;
import org.wso2.msf4j.Session;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.internal.HttpHeadersImpl;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class Request {
    private final HTTPCarbonMessage httpCarbonMessage;
    private List<String> acceptTypes = null;
    private String contentType = null;
    private SessionManager sessionManager;
    private Session session;

    public Request(HTTPCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
        String acceptHeaderStr = httpCarbonMessage.getHeader("Accept");
        this.acceptTypes = acceptHeaderStr != null ? Arrays.stream(acceptHeaderStr.split("\\s*,\\s*")).map(mediaType -> mediaType.split("\\s*;\\s*")[0]).collect(Collectors.toList()) : null;
        String contentTypeHeaderStr = httpCarbonMessage.getHeader("Content-Type");
        this.contentType = contentTypeHeaderStr != null ? contentTypeHeaderStr.split("\\s*;\\s*")[0] : null;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean isEmpty() {
        return this.httpCarbonMessage.isEmpty();
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.httpCarbonMessage.getMessageBody();
    }

    public HttpHeaders getHeaders() {
        return new HttpHeadersImpl(this.httpCarbonMessage.getHeaders());
    }

    public String getHeader(String key) {
        return this.httpCarbonMessage.getHeader(key);
    }

    public Object getProperty(String key) {
        return this.httpCarbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.httpCarbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.httpCarbonMessage.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.httpCarbonMessage.removeProperty(key);
    }

    public String getUri() {
        return (String)this.httpCarbonMessage.getProperty("TO");
    }

    public String getHttpMethod() {
        return (String)this.httpCarbonMessage.getProperty("HTTP_METHOD");
    }

    public List<String> getAcceptTypes() {
        return this.acceptTypes;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Session getSession() {
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager has not been set");
        }
        if (this.session != null) {
            return this.session.setAccessed();
        }
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader != null) {
            this.session = Arrays.stream(cookieHeader.split(";")).map(String::trim).filter(cookie -> cookie.startsWith("JSESSIONID=")).findFirst().map(jsession -> this.sessionManager.getSession(jsession.substring("JSESSIONID=".length()))).orElseGet(this.sessionManager::createSession);
            return this.session.setAccessed();
        }
        this.session = this.sessionManager.createSession();
        return this.session;
    }

    public Session getSession(boolean create) {
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager has not been set");
        }
        if (this.session != null) {
            return this.session.setAccessed();
        }
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader != null) {
            this.session = Arrays.stream(cookieHeader.split(";")).map(String::trim).filter(cookie -> cookie.startsWith("JSESSIONID=")).findFirst().map(jsession -> this.sessionManager.getSession(jsession.substring("JSESSIONID=".length()))).orElseGet(() -> {
                if (create) {
                    return this.sessionManager.createSession();
                }
                return null;
            });
            return this.session.setAccessed();
        }
        if (create) {
            this.session = this.sessionManager.createSession();
            return this.session;
        }
        return null;
    }

    Session getSessionInternal() {
        return this.session;
    }

    HTTPCarbonMessage getHttpCarbonMessage() {
        return this.httpCarbonMessage;
    }

    public boolean respond(HTTPCarbonMessage carbonMessage) throws ServerConnectorException {
        HttpResponseFuture statusFuture = this.httpCarbonMessage.respond(carbonMessage);
        return statusFuture.getStatus().getCause() == null;
    }

    public InputStream getMessageContentStream() {
        return new HttpMessageDataStreamer(this.httpCarbonMessage).getInputStream();
    }
}

