/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import java.util.Map;
import java.util.TreeMap;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;
import org.wso2.carbon.metrics.core.Level;

@Configuration(description="Metrics Levels are organized from most specific to least:\nOFF (most specific, no metrics)\nINFO\nDEBUG\nTRACE (least specific, a lot of data)\nALL (least specific, all data)")
public class MetricsLevelConfig {
    @Element(description="The root level configured for Metrics")
    private String rootLevel = Level.INFO.name();
    @Element(description="Metric Levels")
    private Map<String, String> levels = new TreeMap<String, String>();

    public MetricsLevelConfig() {
        this.levels.put("jvm.buffers", Level.OFF.name());
        this.levels.put("jvm.class-loading", Level.INFO.name());
        this.levels.put("jvm.gc", Level.DEBUG.name());
        this.levels.put("jvm.memory", Level.INFO.name());
        this.levels.put("jvm.memory.heap", Level.INFO.name());
        this.levels.put("jvm.memory.non-heap", Level.INFO.name());
        this.levels.put("jvm.memory.total", Level.INFO.name());
        this.levels.put("jvm.memory.pools", Level.OFF.name());
        this.levels.put("jvm.os", Level.INFO.name());
        this.levels.put("jvm.threads", Level.OFF.name());
        this.levels.put("jvm.threads.count", Level.DEBUG.name());
        this.levels.put("jvm.threads.daemon.count", Level.DEBUG.name());
        this.levels.put("jvm.threads.blocked.count", Level.OFF.name());
        this.levels.put("jvm.threads.deadlock.count", Level.OFF.name());
        this.levels.put("jvm.threads.new.count", Level.OFF.name());
        this.levels.put("jvm.threads.runnable.count", Level.OFF.name());
        this.levels.put("jvm.threads.terminated.count", Level.OFF.name());
        this.levels.put("jvm.threads.timed_waiting.count", Level.OFF.name());
        this.levels.put("jvm.threads.waiting.count", Level.OFF.name());
    }

    public String getRootLevel() {
        return this.rootLevel;
    }

    public void setRootLevel(String rootLevel) {
        this.rootLevel = rootLevel;
    }

    public Map<String, String> getLevels() {
        return this.levels;
    }

    public void setLevels(Map<String, String> levels) {
        this.levels = levels;
    }
}

