/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.internal;

import java.nio.file.Path;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.SecureVaultUtils;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.internal.SecureVaultDataHolder;
import org.wso2.carbon.utils.Utils;

public class SecureVaultActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultActivator.class);

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        try {
            SecureVaultDataHolder.getInstance().setBundleContext(bundleContext);
            logger.debug("Starting Secure Vault bundle");
            logger.debug("Initializing Secure Vault config...");
            Path secureVaultYAMLPath = Utils.getRuntimeConfigPath().resolve("deployment.yaml");
            SecureVaultDataHolder.getInstance().setSecureVaultConfiguration(SecureVaultUtils.getSecureVaultConfig(secureVaultYAMLPath).orElseThrow(() -> new SecureVaultException("Error occurred when obtaining secure vault configuration.")));
            logger.debug("Secure vault config successfully initialized");
        }
        catch (Throwable throwable) {
            logger.error("Error occurred when initializing secure vault.", throwable);
            throw new SecureVaultException("Error occurred when initializing secure vault.", throwable);
        }
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        SecureVaultDataHolder.getInstance().setBundleContext(null);
        logger.debug("Secure Vault Activator successfully stopped");
    }
}

