/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.sample.httpmonitoring.service;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.sample.httpmonitoring.service.Student;

@Path(value="/student")
@Timed
public class StudentService {
    private Map<String, Student> students = new ConcurrentHashMap<String, Student>();

    public StudentService() {
        Student student = new Student();
        student.setNic("910760234V");
        student.setFirstName("Joseph");
        student.setLastName("Rodgers");
        student.setAge(14);
        this.addStudent(student);
    }

    @GET
    @Path(value="/{nic}")
    @Produces(value={"application/json"})
    @HTTPMonitored(tracing=true)
    public Student getStudent(@PathParam(value="nic") String nic) {
        return this.students.get(nic);
    }

    @POST
    @Consumes(value={"application/json"})
    @HTTPMonitored(tracing=true)
    public void addStudent(Student student) {
        this.students.put(student.getNic(), student);
    }

    @GET
    @Produces(value={"application/json"})
    @HTTPMonitored
    public Collection<Student> getAll() {
        return this.students.values();
    }
}

