/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.states;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contract.config.KeepAliveConfig;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.listener.states.ListenerReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.listener.states.SendingHeaders;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class StateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StateUtil.class);
    public static final String ILLEGAL_STATE_ERROR = "is not a valid action of this state";
    public static final String CONNECTOR_NOTIFYING_ERROR = "Error while notifying error state to server-connector listener";

    private StateUtil() {
    }

    public static boolean checkChunkingCompatibility(String httpVersion, ChunkConfig chunkConfig) {
        return Util.isVersionCompatibleForChunking(httpVersion) || Util.shouldEnforceChunkingforHttpOneZero(chunkConfig, httpVersion);
    }

    public static void notifyIfHeaderWriteFailure(HttpResponseFuture httpResponseStatusFuture, ChannelFuture outboundHeaderFuture, String errorMsg) {
        outboundHeaderFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException(errorMsg);
                }
                httpResponseStatusFuture.notifyHttpListener(throwable);
            }
        }));
    }

    public static ChannelFuture sendRequestTimeoutResponse(ChannelHandlerContext ctx, HttpResponseStatus status, ByteBuf content, int length, float httpVersion, String serverName) {
        DefaultFullHttpResponse outboundResponse = httpVersion == 1.0f ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, status, content) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
        if (length != 0) {
            outboundResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        }
        outboundResponse.headers().set(HttpHeaderNames.CONNECTION.toString(), (Object)"close");
        outboundResponse.headers().set(HttpHeaderNames.SERVER.toString(), (Object)serverName);
        return ctx.channel().writeAndFlush(outboundResponse);
    }

    public static void handleIncompleteInboundMessage(HttpCarbonMessage inboundRequestMsg, String errorMessage) {
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        DecoderException exception = new DecoderException(errorMessage);
        lastHttpContent.setDecoderResult(DecoderResult.failure(exception));
        if (inboundRequestMsg != null) {
            inboundRequestMsg.addHttpContent(lastHttpContent);
            inboundRequestMsg.notifyContentFailure(exception);
        }
        LOG.warn(errorMessage);
    }

    public static void respondToIncompleteRequest(Channel channel, HttpOutboundRespListener outboundResponseListener, ListenerReqRespStateManager listenerReqRespStateManager, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, String errorMsg) {
        channel.config().setAutoRead(false);
        if (outboundResponseListener.getInboundRequestMsg().getIoException() == null) {
            StateUtil.handleIncompleteInboundMessage(outboundResponseListener.getInboundRequestMsg(), errorMsg);
        }
        outboundResponseListener.setKeepAliveConfig(KeepAliveConfig.NEVER);
        listenerReqRespStateManager.state = new SendingHeaders(listenerReqRespStateManager, outboundResponseListener);
        listenerReqRespStateManager.writeOutboundResponseHeaders(outboundResponseMsg, httpContent);
    }

    public static void addTrailerHeaderIfPresent(HttpCarbonMessage outboundResponseMsg) {
        if (outboundResponseMsg.getTrailerHeaders().isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, String> header : outboundResponseMsg.getTrailerHeaders().entries()) {
            names.add(header.getKey());
        }
        String trailerHeaderValue = String.join((CharSequence)", ", names);
        outboundResponseMsg.setHeader(HttpHeaderNames.TRAILER.toString(), trailerHeaderValue);
    }

    public static void setInboundTrailersToNewMessage(HttpHeaders trailers, HttpCarbonMessage responseMsg) {
        if (trailers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : trailers.entries()) {
            responseMsg.getTrailerHeaders().set(header.getKey(), (Object)header.getValue());
        }
        trailers.clear();
    }
}

