/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.util.Set;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.YAMLTransportConfigurationBuilder;

public class RequestSizeValidationConfiguration {
    private static RequestSizeValidationConfiguration instance = new RequestSizeValidationConfiguration();
    private boolean requestSizeValidation = false;
    private int requestMaxSize = Integer.MAX_VALUE;
    private int requestRejectStatusCode = 401;
    private String requestRejectMessage = "Message is bigger than the valid size";
    private String requestRejectMsgContentType = "plain/text";
    private boolean headerSizeValidation = false;
    private int headerMaxRequestLineSize = 4096;
    private int headerMaxSize = 8192;
    private int maxChunkSize = 8192;
    private int headerRejectStatusCode = 401;
    private String headerRejectMessage = "Message header is bigger than the valid size";
    private String headerRejectMsgContentType = "plain/text";

    private RequestSizeValidationConfiguration() {
        Set<TransportProperty> transportProperties = YAMLTransportConfigurationBuilder.build().getTransportProperties();
        transportProperties.forEach(transportProperty -> {
            if (transportProperty.getName().equalsIgnoreCase("request.size.validation")) {
                this.requestSizeValidation = (Boolean)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("request.size.validation.maximum.value")) {
                this.requestMaxSize = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("request.size.validation.reject.status.code")) {
                this.requestRejectStatusCode = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("request.size.validation.reject.message")) {
                this.requestRejectMessage = (String)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("request.size.validation.reject.message.content.type")) {
                this.requestRejectMsgContentType = (String)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.size.validation")) {
                this.headerSizeValidation = (Boolean)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.maximum.request.line")) {
                this.headerMaxRequestLineSize = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.maximum.size")) {
                this.headerMaxSize = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.maximum.chunk.size")) {
                this.maxChunkSize = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.reject.status.code")) {
                this.headerRejectStatusCode = (Integer)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.reject.message")) {
                this.headerRejectMessage = (String)transportProperty.getValue();
            }
            if (transportProperty.getName().equalsIgnoreCase("header.validation.reject.message.content.type")) {
                this.headerRejectMsgContentType = (String)transportProperty.getValue();
            }
        });
    }

    public static RequestSizeValidationConfiguration getInstance() {
        return instance;
    }

    public boolean isRequestSizeValidation() {
        return this.requestSizeValidation;
    }

    public int getRequestMaxSize() {
        return this.requestMaxSize;
    }

    public int getRequestRejectStatusCode() {
        return this.requestRejectStatusCode;
    }

    public String getRequestRejectMessage() {
        return this.requestRejectMessage;
    }

    public String getRequestRejectMsgContentType() {
        return this.requestRejectMsgContentType;
    }

    public boolean isHeaderSizeValidation() {
        return this.headerSizeValidation;
    }

    public int getHeaderMaxRequestLineSize() {
        return this.headerMaxRequestLineSize;
    }

    public int getHeaderMaxSize() {
        return this.headerMaxSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getHeaderRejectStatusCode() {
        return this.headerRejectStatusCode;
    }

    public String getHeaderRejectMessage() {
        return this.headerRejectMessage;
    }

    public String getHeaderRejectMsgContentType() {
        return this.headerRejectMsgContentType;
    }
}

