/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.sender.TargetHandler;
import org.wso2.carbon.transport.http.netty.sender.WorkerPoolDispatchingTargetHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;

public class NettyClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(NettyClientInitializer.class);
    private SenderConfiguration senderConfiguration;
    protected static final String HANDLER = "handler";
    private TargetHandler handler;
    private int soTimeOut;

    public NettyClientInitializer(SenderConfiguration senderConfiguration) {
        this.senderConfiguration = senderConfiguration;
        this.soTimeOut = BootstrapConfiguration.getInstance().getSocketTimeout();
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.senderConfiguration.getSslConfig() != null) {
            log.debug("adding ssl handler");
            SslHandler sslHandler = new SSLHandlerFactory(this.senderConfiguration.getSslConfig()).create();
            sslHandler.engine().setUseClientMode(true);
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        ch.pipeline().addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        ch.pipeline().addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        ch.pipeline().addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        ch.pipeline().addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        if (this.senderConfiguration.isDisruptorOn()) {
            log.debug("Register target handler in pipeline which will dispatch events to Disruptor threads");
            this.handler = new TargetHandler(this.soTimeOut);
            ch.pipeline().addLast(HANDLER, (ChannelHandler)this.handler);
        } else {
            log.debug("Register  engine dispatching handler in pipeline ");
            this.handler = new WorkerPoolDispatchingTargetHandler(this.soTimeOut);
            ch.pipeline().addLast(HANDLER, (ChannelHandler)this.handler);
        }
    }

    public TargetHandler getTargetHandler() {
        return this.handler;
    }
}

