/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.wso2.carbon.messaging.Header;

public class Headers {
    private Map<String, String> headerMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private List<Header> headerList = new LinkedList<Header>();

    public Headers() {
    }

    public Headers(List<Header> list) {
        this.set(list);
    }

    public void set(String name, String value) {
        this.headerList.removeIf(header -> header.getName().equalsIgnoreCase(name));
        this.add(name, value);
    }

    public void set(Map<String, String> map) {
        map.forEach(this::add);
    }

    public void set(List<Header> list) {
        list.forEach(h -> this.add(h.getName(), h.getValue()));
    }

    public void remove(String name) {
        this.headerList.removeIf(header -> header.getName().equalsIgnoreCase(name));
        this.headerMap.remove(name);
    }

    public String get(String name) {
        return this.headerMap.get(name);
    }

    public List<Header> getAll() {
        return this.headerList;
    }

    public List<String> getAllBy(String name) {
        List hList = this.headerList.stream().filter(entry -> entry.getName().equalsIgnoreCase(name)).map(Header::getValue).collect(Collectors.toCollection(LinkedList::new));
        return hList;
    }

    public boolean contains(String name) {
        return this.headerMap.containsKey(name);
    }

    public void clear() {
        this.headerList.clear();
        this.headerMap.clear();
    }

    public int distinctSize() {
        return this.headerMap.size();
    }

    public int size() {
        return this.headerList.size();
    }

    private void add(String key, String value) {
        this.headerList.add(new Header(key, value));
        this.headerMap.put(key, value);
    }
}

