/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.config;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.carbon.transport.http.netty.common.TransportThreadFactory;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SenderConfiguration {
    public static final String DEFAULT_KEY = "netty";
    private boolean disruptorOn = true;
    private ExecutorService executorService;
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String senderWorkerThreads = "4";
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePass;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters;

    public static SenderConfiguration getDefault() {
        SenderConfiguration defaultConfig = new SenderConfiguration(DEFAULT_KEY);
        return defaultConfig;
    }

    public SenderConfiguration() {
    }

    public SenderConfiguration(String id) {
        this.id = id;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public String getSenderWorkerThreads() {
        return this.senderWorkerThreads;
    }

    public void setSenderWorkerThreads(String senderWorkerThreads) {
        this.senderWorkerThreads = senderWorkerThreads;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return Util.getSSLConfigForSender(this.certPass, this.keyStorePass, this.keyStoreFile, this.trustStoreFile, this.trustStorePass, this.parameters);
    }

    public boolean isDisruptorOn() {
        return this.disruptorOn;
    }

    public void setDisruptorOn(boolean disruptorOn) {
        this.disruptorOn = disruptorOn;
    }

    public ExecutorService getNettyHandlerExecutorService() {
        return this.executorService;
    }

    public void setNettyHandlerWorkerPool(int nettyHandlerWorkerPool) {
        this.executorService = Executors.newFixedThreadPool(nettyHandlerWorkerPool, new TransportThreadFactory(new ThreadGroup("Transport-Sender-Worker-Pool")));
    }
}

