/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.ResponseContentWriter;
import org.wso2.carbon.transport.http.netty.message.NettyCarbonMessage;

public class ResponseCallback
implements CarbonCallback {
    private ChannelHandlerContext ctx;
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCallback.class);
    private static final String HTTP_CONNECTION_CLOSE = "close";

    public ResponseCallback(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void done(CarbonMessage cMsg) {
        block8: {
            String connection;
            block9: {
                this.handleResponsesWithoutContentLength(cMsg);
                if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseReceiving(cMsg);
                }
                HttpResponse response = Util.createHttpResponse(cMsg);
                this.ctx.write(response);
                if (cMsg.isBufferContent()) break block9;
                cMsg.setWriter(new ResponseContentWriter(this.ctx));
                break block8;
            }
            if (cMsg instanceof NettyCarbonMessage) {
                NettyCarbonMessage nettyCMsg = (NettyCarbonMessage)cMsg;
                while (true) {
                    if (nettyCMsg.isEndOfMsgAdded() && nettyCMsg.isEmpty()) {
                        this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                        break block8;
                    }
                    HttpContent httpContent = nettyCMsg.getHttpContent();
                    if (httpContent instanceof LastHttpContent) {
                        this.ctx.writeAndFlush(httpContent);
                        if (NettyTransportContextHolder.getInstance().getHandlerExecutor() == null) break block8;
                        NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
                        break block8;
                    }
                    this.ctx.write(httpContent);
                }
            }
            if (!(cMsg instanceof DefaultCarbonMessage)) break block8;
            DefaultCarbonMessage defaultCMsg = (DefaultCarbonMessage)cMsg;
            do {
                ByteBuffer byteBuffer = defaultCMsg.getMessageBody();
                ByteBuf bbuf = Unpooled.wrappedBuffer(byteBuffer);
                DefaultHttpContent httpContent = new DefaultHttpContent(bbuf);
                this.ctx.write(httpContent);
            } while (!defaultCMsg.isEndOfMsgAdded() || !defaultCMsg.isEmpty());
            ChannelFuture future = this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
            }
            if ((connection = cMsg.getHeader("Connection")) != null && HTTP_CONNECTION_CLOSE.equalsIgnoreCase(connection)) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private void handleResponsesWithoutContentLength(CarbonMessage cMsg) {
        if (cMsg.getHeader("Transfer-Encoding") == null && cMsg.getHeader("Content-Length") == null) {
            cMsg.setHeader("Content-Length", String.valueOf(cMsg.getFullMessageLength()));
        }
    }
}

