/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.formparam;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.formparam.FormItem;
import org.wso2.msf4j.formparam.MultipartStream;
import org.wso2.msf4j.formparam.ParameterParser;
import org.wso2.msf4j.formparam.RequestContext;
import org.wso2.msf4j.formparam.exception.FormUploadException;
import org.wso2.msf4j.formparam.exception.InvalidContentTypeException;
import org.wso2.msf4j.formparam.util.FormItemHeader;

public class FormParamIterator
implements Iterator {
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String CONTENT_LENGTH = "Content-length";
    private static final String FORM_DATA = "form-data";
    private static final String ATTACHMENT = "attachment";
    private static final String MULTIPART = "multipart/";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private final MultipartStream multi;
    private final byte[] boundary;
    private FormItem currentItem;
    private String currentFieldName;
    private boolean skipPreamble;
    private boolean itemValid;
    private boolean eof;

    public FormParamIterator(Request request) throws FormUploadException, IOException {
        this(new RequestContext(request));
    }

    private byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return new byte[0];
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes(Charset.defaultCharset());
        }
        return boundary;
    }

    private String getFileName(FormItemHeader headers) {
        return this.getFileName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase(Locale.ENGLISH)).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    private String getFieldName(FormItemHeader headers) {
        return this.getFieldName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String pContentDisposition) {
        String fieldName = null;
        if (pContentDisposition != null && pContentDisposition.toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    private FormItemHeader getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        FormItemHeader headers = this.newFileItemHeaders();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            StringBuilder header = new StringBuilder(headerPart.substring(start, end));
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header.append(" ").append(headerPart.substring(nonWs, end));
                start = end + 2;
            }
            this.parseHeaderLine(headers, header.toString());
        }
        return headers;
    }

    private FormItemHeader newFileItemHeaders() {
        return new FormItemHeader();
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(FormItemHeader headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        headers.addHeader(headerName, headerValue);
    }

    private FormParamIterator(RequestContext ctx) throws FormUploadException, IOException {
        if (ctx == null) {
            throw new NullPointerException("ctx parameter");
        }
        String contentType = ctx.getContentType();
        if (null == contentType || !contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART)) {
            throw new InvalidContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", MULTIPART_FORM_DATA, MULTIPART_MIXED, contentType));
        }
        InputStream input = ctx.getInputStream();
        String charEncoding = ctx.getCharacterEncoding();
        this.boundary = this.getBoundary(contentType);
        if (this.boundary.length == 0) {
            IOUtils.closeQuietly(input);
            throw new FormUploadException("the request was rejected because no multipart boundary was found");
        }
        try {
            this.multi = new MultipartStream(input, this.boundary);
        }
        catch (IllegalArgumentException iae) {
            IOUtils.closeQuietly(input);
            throw new InvalidContentTypeException(String.format("The boundary specified in the %s header is too long", CONTENT_TYPE), iae);
        }
        this.multi.setHeaderEncoding(charEncoding);
        this.skipPreamble = true;
        this.findNextItem();
    }

    private boolean findNextItem() {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        while (true) {
            boolean nextPart;
            if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                this.multi.setBoundary(this.boundary);
                this.currentFieldName = null;
                continue;
            }
            FormItemHeader headers = this.getParsedHeaders(this.multi.readHeaders());
            if (this.currentFieldName == null) {
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = headers.getHeader(CONTENT_TYPE);
                    if (subContentType != null && subContentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART_MIXED)) {
                        this.currentFieldName = fieldName;
                        byte[] subBoundary = this.getBoundary(subContentType);
                        this.multi.setBoundary(subBoundary);
                        this.skipPreamble = true;
                        continue;
                    }
                    String fileName = this.getFileName(headers);
                    this.currentItem = new FormItem(fileName, fieldName, headers.getHeader(CONTENT_TYPE), fileName == null, this.getContentLength(headers), this.multi);
                    this.currentItem.setHeaders(headers);
                    this.itemValid = true;
                    return true;
                }
            } else {
                String fileName = this.getFileName(headers);
                if (fileName != null) {
                    this.currentItem = new FormItem(fileName, this.currentFieldName, headers.getHeader(CONTENT_TYPE), false, this.getContentLength(headers), this.multi);
                    this.currentItem.setHeaders(headers);
                    this.itemValid = true;
                    return true;
                }
            }
            this.multi.discardBodyData();
        }
    }

    private long getContentLength(FormItemHeader pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader(CONTENT_LENGTH));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        return this.itemValid || this.findNextItem();
    }

    public FormItem next() {
        if (this.eof || !this.itemValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.itemValid = false;
        return this.currentItem;
    }
}

