/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.beanconversion;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.wso2.msf4j.beanconversion.BeanConversionException;
import org.wso2.msf4j.beanconversion.MediaTypeConverter;

public class JsonConverter
extends MediaTypeConverter {
    private static final Gson gson = new Gson();
    private static final String TEXT_JSON = "text/json";

    @Override
    public String[] getSupportedMediaTypes() {
        return new String[]{"application/json", TEXT_JSON};
    }

    @Override
    public ByteBuffer toMedia(Object object) {
        String value = object instanceof String || object instanceof JsonArray || object instanceof JsonObject ? object.toString() : gson.toJson(object);
        return ByteBuffer.wrap(value.getBytes(Charset.defaultCharset()));
    }

    @Override
    public Object toObject(ByteBuffer content, Type targetType) throws BeanConversionException {
        try {
            String str = Charset.defaultCharset().decode(content).toString();
            Object object = gson.fromJson(str, targetType);
            if (object == null) {
                throw new BeanConversionException("Unable to perform json to object conversion");
            }
            return object;
        }
        catch (JsonSyntaxException ex) {
            throw new BeanConversionException("Unable to perform json to object conversion", ex);
        }
    }
}

