/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.delegates;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    private static final String DATE_FORMAT_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String GMT_TIMEZONE = "GMT";
    private static final String VERSION = "Version";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String SECURE = "Secure";
    private static final String EXPIRES = "Expires";
    private static final String COMMENT = "Comment";
    private static final String HTTP_ONLY = "HttpOnly";
    private static final String MAX_AGE = "MaxAge";
    private static final Logger log = LoggerFactory.getLogger(CookieHeaderProvider.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);

    @Override
    public Cookie fromString(String cookieValue) {
        String[] parts;
        if (cookieValue == null) {
            throw new IllegalArgumentException("Cookie value can not be null");
        }
        int version = 1;
        int maxAge = -1;
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        String comment = null;
        Date expiry = null;
        boolean secure = false;
        boolean httpOnly = false;
        for (String part : parts = cookieValue.split(";")) {
            String token = part.trim();
            if (token.startsWith(VERSION)) {
                version = Integer.parseInt(token.substring(VERSION.length() + 1));
                continue;
            }
            if (token.startsWith(PATH)) {
                path = token.substring(PATH.length() + 1);
                continue;
            }
            if (token.startsWith(DOMAIN)) {
                domain = token.substring(DOMAIN.length() + 1);
                continue;
            }
            if (token.startsWith(SECURE)) {
                secure = Boolean.TRUE;
                continue;
            }
            if (token.startsWith(HTTP_ONLY)) {
                httpOnly = Boolean.TRUE;
                continue;
            }
            if (token.startsWith(COMMENT)) {
                comment = token.substring(COMMENT.length() + 1);
                continue;
            }
            if (token.startsWith(MAX_AGE)) {
                maxAge = Integer.parseInt(token.substring(MAX_AGE.length() + 1));
                continue;
            }
            if (token.startsWith(EXPIRES)) {
                try {
                    this.dateFormat.setTimeZone(TimeZone.getTimeZone(GMT_TIMEZONE));
                    expiry = this.dateFormat.parse(token.substring(EXPIRES.length() + 1));
                }
                catch (ParseException e) {
                    log.error("Error while parsing the Date value. Hence return null", e);
                }
                continue;
            }
            int i = token.indexOf(61);
            if (i == -1) continue;
            name = token.substring(0, i);
            value = i == token.length() + 1 ? "" : token.substring(i + 1);
        }
        if (name == null) {
            throw new IllegalArgumentException("Cookie is malformed : " + cookieValue);
        }
        return new NewCookie(name, value, path, domain, version, comment, maxAge, expiry, secure, httpOnly);
    }

    @Override
    public String toString(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        if (cookie.getVersion() != 1) {
            sb.append(VERSION).append('=').append(cookie.getVersion()).append(';');
        }
        sb.append(cookie.getName()).append('=').append(cookie.getValue());
        if (cookie.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(cookie.getDomain());
        }
        if (cookie instanceof NewCookie) {
            NewCookie newCookie = (NewCookie)cookie;
            if (newCookie.getMaxAge() != -1) {
                sb.append(';').append(MAX_AGE).append('=').append(newCookie.getMaxAge());
            }
            if (newCookie.getComment() != null) {
                sb.append(';').append(COMMENT).append('=').append(newCookie.getComment());
            }
            if (newCookie.getExpiry() != null) {
                this.dateFormat.setTimeZone(TimeZone.getTimeZone(GMT_TIMEZONE));
                sb.append(';').append(EXPIRES).append('=').append(this.dateFormat.format(newCookie.getExpiry()));
            }
            if (newCookie.isSecure()) {
                sb.append(';').append(SECURE);
            }
            if (newCookie.isHttpOnly()) {
                sb.append(';').append(HTTP_ONLY);
            }
        }
        return sb.toString();
    }
}

